/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/acra/util/PackageManagerWrapper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getPackageInfo", "Landroid/content/pm/PackageInfo;", "hasPermission", "", "permission", "", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nPackageManagerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageManagerWrapper.kt\norg/acra/util/PackageManagerWrapper\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,70:1\n15#2,2:71\n*S KotlinDebug\n*F\n+ 1 PackageManagerWrapper.kt\norg/acra/util/PackageManagerWrapper\n*L\n62#1:71,2\n*E\n"})
public final class PackageManagerWrapper {
    @NotNull
    private final Context context;

    public PackageManagerWrapper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final boolean hasPermission(@NotNull String permission) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        PackageManager pm = packageManager;
        try {
            bl = pm.checkPermission(permission, this.context.getPackageName()) == 0;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final PackageInfo getPackageInfo() {
        PackageInfo packageInfo;
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        PackageManager pm = packageManager;
        try {
            packageInfo = pm.getPackageInfo(this.context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Failed to find PackageInfo for current App : " + this.context.getPackageName();
            aCRALog.w(string, string2);
            packageInfo = null;
        }
        catch (Exception e) {
            packageInfo = null;
        }
        return packageInfo;
    }
}

