/*
 * Decompiled with CFR 0.152.
 */
package org.acra.reporter;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.ErrorReporter;
import org.acra.builder.LastActivityManager;
import org.acra.builder.ReportBuilder;
import org.acra.builder.ReportExecutor;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportDataFactory;
import org.acra.log.ACRALog;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.scheduler.SchedulerStarter;
import org.acra.scheduler.SenderScheduler;
import org.acra.startup.StartupProcessorExecutor;
import org.acra.util.ProcessFinisher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0012\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001a\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\tH\u0016J\u0012\u0010!\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001a\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010,\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/acra/reporter/ErrorReporterImpl;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "Lorg/acra/ErrorReporter;", "context", "Landroid/app/Application;", "config", "Lorg/acra/config/CoreConfiguration;", "enabled", "", "supportedAndroidVersion", "checkReportsOnApplicationStart", "(Landroid/app/Application;Lorg/acra/config/CoreConfiguration;ZZZ)V", "customData", "", "", "defaultExceptionHandler", "reportExecutor", "Lorg/acra/builder/ReportExecutor;", "reportScheduler", "Lorg/acra/scheduler/SenderScheduler;", "getReportScheduler", "()Lorg/acra/scheduler/SenderScheduler;", "schedulerStarter", "Lorg/acra/scheduler/SchedulerStarter;", "clearCustomData", "", "getCustomData", "key", "handleException", "e", "", "endApplication", "handleSilentException", "onSharedPreferenceChanged", "sharedPreferences", "Landroid/content/SharedPreferences;", "putCustomData", "value", "removeCustomData", "setEnabled", "uncaughtException", "t", "Ljava/lang/Thread;", "unregister", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nErrorReporterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorReporterImpl.kt\norg/acra/reporter/ErrorReporterImpl\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,175:1\n27#2,2:176\n7#2,2:178\n27#2,2:180\n11#2,2:182\n15#2,2:184\n*S KotlinDebug\n*F\n+ 1 ErrorReporterImpl.kt\norg/acra/reporter/ErrorReporterImpl\n*L\n96#1:176,2\n97#1:178,2\n108#1:180,2\n123#1:182,2\n126#1:184,2\n*E\n"})
public final class ErrorReporterImpl
implements Thread.UncaughtExceptionHandler,
SharedPreferences.OnSharedPreferenceChangeListener,
ErrorReporter {
    @NotNull
    private final Application context;
    private final boolean supportedAndroidVersion;
    @NotNull
    private final ReportExecutor reportExecutor;
    @NotNull
    private final Map<String, String> customData;
    @NotNull
    private final SchedulerStarter schedulerStarter;
    @Nullable
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;

    public ErrorReporterImpl(@NotNull Application context, @NotNull CoreConfiguration config, boolean enabled, boolean supportedAndroidVersion, boolean checkReportsOnApplicationStart) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.supportedAndroidVersion = supportedAndroidVersion;
        this.customData = new HashMap();
        CrashReportDataFactory crashReportDataFactory = new CrashReportDataFactory((Context)this.context, config);
        crashReportDataFactory.collectStartUp();
        this.defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        LastActivityManager lastActivityManager = new LastActivityManager(this.context);
        ProcessFinisher processFinisher = new ProcessFinisher((Context)this.context, config, lastActivityManager);
        this.schedulerStarter = new SchedulerStarter((Context)this.context, config);
        this.reportExecutor = new ReportExecutor((Context)this.context, config, crashReportDataFactory, this.defaultExceptionHandler, processFinisher, this.schedulerStarter, lastActivityManager);
        this.reportExecutor.setEnabled(enabled);
        if (checkReportsOnApplicationStart) {
            new StartupProcessorExecutor((Context)this.context, config, this.schedulerStarter).processReports(enabled);
        }
    }

    @Override
    @Nullable
    public String putCustomData(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.customData.put(key, value);
    }

    @Override
    @Nullable
    public String removeCustomData(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.customData.remove(key);
    }

    @Override
    public void clearCustomData() {
        this.customData.clear();
    }

    @Override
    @Nullable
    public String getCustomData(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.customData.get(key);
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.reportExecutor.isEnabled()) {
            this.reportExecutor.handReportToDefaultExceptionHandler(t, e);
            return;
        }
        try {
            boolean $i$f$error = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            Object object = "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.context.getPackageName();
            aCRALog.e(string, (String)object, e);
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl2 = false;
                object = "Building report";
                aCRALog.d(string, (String)object);
            }
            new ReportBuilder().uncaughtExceptionThread(t).exception(e).customData(this.customData).endApplication().build(this.reportExecutor);
        }
        catch (Exception fatality) {
            boolean $i$f$error = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "ACRA failed to capture the error - handing off to native error reporter";
            aCRALog.e(string, string2, fatality);
            this.reportExecutor.handReportToDefaultExceptionHandler(t, e);
        }
    }

    @Override
    public void handleSilentException(@Nullable Throwable e) {
        new ReportBuilder().exception(e).customData(this.customData).sendSilently().build(this.reportExecutor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.supportedAndroidVersion) {
            boolean $i$f$info = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "ACRA is " + (enabled ? "enabled" : "disabled") + " for " + this.context.getPackageName();
            aCRALog.i(string, string2);
            this.reportExecutor.setEnabled(enabled);
        } else {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "ACRA requires ICS or greater. ACRA is disabled and will NOT catch crashes or send messages.";
            aCRALog.w(string, string3);
        }
    }

    @Override
    public void handleException(@Nullable Throwable e, boolean endApplication) {
        ReportBuilder builder = new ReportBuilder();
        builder.exception(e).customData(this.customData);
        if (endApplication) {
            builder.endApplication();
        }
        builder.build(this.reportExecutor);
    }

    @Override
    public void handleException(@Nullable Throwable e) {
        this.handleException(e, false);
    }

    @Override
    @NotNull
    public SenderScheduler getReportScheduler() {
        return this.schedulerStarter.getSenderScheduler();
    }

    public void onSharedPreferenceChanged(@NotNull SharedPreferences sharedPreferences, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        if (Intrinsics.areEqual((Object)"acra.disable", (Object)key) || Intrinsics.areEqual((Object)"acra.enable", (Object)key)) {
            this.setEnabled(SharedPreferencesFactory.Companion.shouldEnableACRA(sharedPreferences));
        }
    }

    public final void unregister() {
        Thread.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
    }
}

