/*
 * Decompiled with CFR 0.152.
 */
package org.acra.builder;

import android.content.Context;
import android.os.Debug;
import android.os.Looper;
import android.os.StrictMode;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.builder.LastActivityManager;
import org.acra.builder.ReportBuilder;
import org.acra.config.CoreConfiguration;
import org.acra.config.ReportingAdministrator;
import org.acra.data.CrashReportData;
import org.acra.data.CrashReportDataFactory;
import org.acra.file.CrashReportPersister;
import org.acra.file.ReportLocator;
import org.acra.interaction.ReportInteractionExecutor;
import org.acra.log.ACRALog;
import org.acra.plugins.PluginLoader;
import org.acra.scheduler.SchedulerStarter;
import org.acra.util.ProcessFinisher;
import org.acra.util.ToastSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001eJ\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/acra/builder/ReportExecutor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "crashReportDataFactory", "Lorg/acra/data/CrashReportDataFactory;", "defaultExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "processFinisher", "Lorg/acra/util/ProcessFinisher;", "schedulerStarter", "Lorg/acra/scheduler/SchedulerStarter;", "lastActivityManager", "Lorg/acra/builder/LastActivityManager;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;Lorg/acra/data/CrashReportDataFactory;Ljava/lang/Thread$UncaughtExceptionHandler;Lorg/acra/util/ProcessFinisher;Lorg/acra/scheduler/SchedulerStarter;Lorg/acra/builder/LastActivityManager;)V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "reportingAdministrators", "", "Lorg/acra/config/ReportingAdministrator;", "endApplication", "", "uncaughtExceptionThread", "Ljava/lang/Thread;", "th", "", "execute", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "getReportFileName", "Ljava/io/File;", "crashData", "Lorg/acra/data/CrashReportData;", "handReportToDefaultExceptionHandler", "t", "e", "saveCrashReportFile", "file", "sendReport", "report", "onlySendSilentReports", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nReportExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportExecutor.kt\norg/acra/builder/ReportExecutor\n+ 2 PluginLoader.kt\norg/acra/plugins/PluginLoaderKt\n+ 3 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,226:1\n30#2:227\n11#3,2:228\n23#3,2:230\n27#3,2:232\n15#3,2:234\n19#3,2:236\n19#3,2:238\n7#3,2:240\n19#3,2:242\n7#3,2:244\n19#3,2:246\n7#3,2:248\n19#3,2:250\n15#3,2:252\n7#3,2:254\n15#3,2:256\n7#3,2:258\n27#3,2:260\n*S KotlinDebug\n*F\n+ 1 ReportExecutor.kt\norg/acra/builder/ReportExecutor\n*L\n54#1:227\n65#1:228,2\n68#1:230,2\n69#1:232,2\n80#1:234,2\n90#1:236,2\n102#1:238,2\n107#1:240,2\n117#1:242,2\n140#1:244,2\n144#1:246,2\n147#1:248,2\n156#1:250,2\n168#1:252,2\n183#1:254,2\n199#1:256,2\n219#1:258,2\n222#1:260,2\n*E\n"})
public final class ReportExecutor {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final CrashReportDataFactory crashReportDataFactory;
    @Nullable
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;
    @NotNull
    private final ProcessFinisher processFinisher;
    @NotNull
    private final SchedulerStarter schedulerStarter;
    @NotNull
    private final LastActivityManager lastActivityManager;
    @NotNull
    private final List<ReportingAdministrator> reportingAdministrators;
    private boolean isEnabled;

    /*
     * WARNING - void declaration
     */
    public ReportExecutor(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull CrashReportDataFactory crashReportDataFactory, @Nullable Thread.UncaughtExceptionHandler defaultExceptionHandler, @NotNull ProcessFinisher processFinisher, @NotNull SchedulerStarter schedulerStarter, @NotNull LastActivityManager lastActivityManager) {
        void $this$loadEnabled$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)crashReportDataFactory, (String)"crashReportDataFactory");
        Intrinsics.checkNotNullParameter((Object)processFinisher, (String)"processFinisher");
        Intrinsics.checkNotNullParameter((Object)schedulerStarter, (String)"schedulerStarter");
        Intrinsics.checkNotNullParameter((Object)lastActivityManager, (String)"lastActivityManager");
        this.context = context;
        this.config = config;
        this.crashReportDataFactory = crashReportDataFactory;
        this.defaultExceptionHandler = defaultExceptionHandler;
        this.processFinisher = processFinisher;
        this.schedulerStarter = schedulerStarter;
        this.lastActivityManager = lastActivityManager;
        PluginLoader pluginLoader = this.config.getPluginLoader();
        CoreConfiguration config$iv = this.config;
        boolean $i$f$loadEnabled = false;
        this.reportingAdministrators = $this$loadEnabled$iv.loadEnabled(config$iv, ReportingAdministrator.class);
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public final void handReportToDefaultExceptionHandler(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.defaultExceptionHandler != null) {
            boolean $i$f$info = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "ACRA is disabled for " + this.context.getPackageName() + " - forwarding uncaught Exception on to default ExceptionHandler";
            aCRALog.i(string, string2);
            this.defaultExceptionHandler.uncaughtException(t, e);
        } else {
            boolean $i$f$error = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "ACRA is disabled for " + this.context.getPackageName() + " - no default ExceptionHandler";
            aCRALog.e(string, string3);
            $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl2 = false;
            string3 = "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.context.getPackageName();
            aCRALog.e(string, string3, e);
        }
    }

    public final void execute(@NotNull ReportBuilder reportBuilder) {
        boolean bl;
        boolean $i$f$warn;
        Object object;
        ACRALog aCRALog;
        String string;
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        if (!this.isEnabled) {
            boolean $i$f$warn2 = false;
            String string2 = ACRA.LOG_TAG;
            ACRALog aCRALog2 = ACRA.log;
            boolean bl2 = false;
            String string3 = "ACRA is disabled. Report not sent.";
            aCRALog2.w(string2, string3);
            return;
        }
        ReportingAdministrator blockingAdministrator = null;
        for (ReportingAdministrator reportingAdministrator : this.reportingAdministrators) {
            try {
                if (reportingAdministrator.shouldStartCollecting(this.context, this.config, reportBuilder)) continue;
                blockingAdministrator = reportingAdministrator;
            }
            catch (Exception t) {
                boolean $i$f$warn3 = false;
                string = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl3 = false;
                object = "ReportingAdministrator " + reportingAdministrator.getClass().getName() + " threw exception";
                aCRALog.w(string, (String)object, t);
            }
        }
        CrashReportData crashReportData = null;
        if (blockingAdministrator == null) {
            crashReportData = this.crashReportDataFactory.createCrashData(reportBuilder);
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldSendReport(this.context, this.config, crashReportData)) continue;
                    blockingAdministrator = administrator;
                }
                catch (Exception t) {
                    boolean $i$f$warn4 = false;
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl4 = false;
                    object = "ReportingAdministrator " + administrator.getClass().getName() + " threw exception";
                    aCRALog.w(string, (String)object, t);
                }
            }
        } else {
            crashReportData = null;
            boolean bl5 = false;
            if (ACRA.DEV_LOGGING) {
                string = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl6 = false;
                object = "Not collecting crash report because of ReportingAdministrator " + blockingAdministrator.getClass().getName();
                aCRALog.d(string, (String)object);
            }
        }
        if (reportBuilder.isEndApplication()) {
            boolean bl7;
            boolean bl8 = true;
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldFinishActivity(this.context, this.config, this.lastActivityManager)) continue;
                    bl7 = false;
                }
                catch (Exception t) {
                    $i$f$warn = false;
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    bl = false;
                    object = "ReportingAdministrator " + administrator.getClass().getName() + " threw exception";
                    aCRALog.w(string, (String)object, t);
                }
            }
            if (bl7) {
                this.processFinisher.finishLastActivity(reportBuilder.getUncaughtExceptionThread());
            }
        }
        if (blockingAdministrator == null) {
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskWrites();
            CrashReportData crashReportData2 = crashReportData;
            Intrinsics.checkNotNull((Object)crashReportData2);
            File reportFile = this.getReportFileName(crashReportData2);
            this.saveCrashReportFile(reportFile, crashReportData);
            ReportInteractionExecutor executor = new ReportInteractionExecutor(this.context, this.config);
            if (reportBuilder.isSendSilently()) {
                this.sendReport(reportFile, executor.hasInteractions());
            } else if (executor.performInteractions(reportFile)) {
                this.sendReport(reportFile, false);
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        } else {
            boolean bl9 = false;
            if (ACRA.DEV_LOGGING) {
                string = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl10 = false;
                object = "Not sending crash report because of ReportingAdministrator " + blockingAdministrator.getClass().getName();
                aCRALog.d(string, (String)object);
            }
            try {
                blockingAdministrator.notifyReportDropped(this.context, this.config);
            }
            catch (Exception exception) {
                boolean $i$f$warn5 = false;
                string = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl11 = false;
                object = "ReportingAdministrator " + blockingAdministrator.getClass().getName() + " threw exeption";
                aCRALog.w(string, (String)object, exception);
            }
        }
        boolean bl12 = false;
        if (ACRA.DEV_LOGGING) {
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl13 = false;
            object = "Wait for Interactions + worker ended. Kill Application ? " + reportBuilder.isEndApplication();
            aCRALog.d(string, (String)object);
        }
        if (reportBuilder.isEndApplication()) {
            boolean bl14;
            boolean bl15 = true;
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldKillApplication(this.context, this.config, reportBuilder, crashReportData)) continue;
                    bl14 = false;
                }
                catch (Exception t) {
                    $i$f$warn = false;
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    bl = false;
                    object = "ReportingAdministrator " + administrator.getClass().getName() + " threw exception";
                    aCRALog.w(string, (String)object, t);
                }
            }
            if (bl14) {
                if (Debug.isDebuggerConnected()) {
                    String warning = "Warning: Acra may behave differently with a debugger attached";
                    new Thread(() -> ReportExecutor.execute$lambda$12(this, warning)).start();
                    boolean $i$f$warn6 = false;
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl16 = false;
                    object = warning;
                    aCRALog.w(string, (String)object);
                } else {
                    Thread thread = reportBuilder.getUncaughtExceptionThread();
                    Throwable throwable = reportBuilder.getException();
                    if (throwable == null) {
                        throwable = new RuntimeException();
                    }
                    this.endApplication(thread, throwable);
                }
            }
        }
    }

    private final void endApplication(Thread uncaughtExceptionThread, Throwable th) {
        boolean letDefaultHandlerEndApplication = this.config.getAlsoReportToAndroidFramework();
        if (uncaughtExceptionThread != null && letDefaultHandlerEndApplication && this.defaultExceptionHandler != null) {
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "Handing Exception on to default ExceptionHandler";
                aCRALog.d(string, string2);
            }
            this.defaultExceptionHandler.uncaughtException(uncaughtExceptionThread, th);
        } else {
            this.processFinisher.endApplication();
        }
    }

    private final void sendReport(File report, boolean onlySendSilentReports) {
        if (this.isEnabled) {
            this.schedulerStarter.scheduleReports(report, onlySendSilentReports);
        } else {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Would be sending reports, but ACRA is disabled";
            aCRALog.w(string, string2);
        }
    }

    private final File getReportFileName(CrashReportData crashData) {
        String timestamp = crashData.getString(ReportField.USER_CRASH_DATE);
        String isSilent = crashData.getString(ReportField.IS_SILENT);
        String fileName = timestamp + (isSilent != null && Boolean.parseBoolean(isSilent) ? ACRAConstants.SILENT_SUFFIX : "") + ".stacktrace";
        ReportLocator reportLocator = new ReportLocator(this.context);
        return new File(reportLocator.getUnapprovedFolder(), fileName);
    }

    private final void saveCrashReportFile(File file, CrashReportData crashData) {
        try {
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "Writing crash report file " + file;
                aCRALog.d(string, string2);
            }
            new CrashReportPersister().store(crashData, file);
        }
        catch (Exception e) {
            boolean $i$f$error = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "An error occurred while writing the report file...";
            aCRALog.e(string, string3, e);
        }
    }

    private static final void execute$lambda$12(ReportExecutor this$0, String $warning) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$warning, (String)"$warning");
        Looper.prepare();
        ToastSender.sendToast(this$0.context, $warning, 1);
        Looper.loop();
    }
}

