/*
 * Decompiled with CFR 0.152.
 */
package org.acra.file;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ACRAConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/acra/file/CrashReportFileNameParser;", "", "()V", "getTimestamp", "Ljava/util/Calendar;", "reportFileName", "", "isApproved", "", "isSilent", "acra-core_release"})
public final class CrashReportFileNameParser {
    public final boolean isSilent(@NotNull String reportFileName) {
        Intrinsics.checkNotNullParameter((Object)reportFileName, (String)"reportFileName");
        return StringsKt.contains$default((CharSequence)reportFileName, (CharSequence)ACRAConstants.SILENT_SUFFIX, (boolean)false, (int)2, null);
    }

    @Deprecated(message="use {@link ReportLocator#getApprovedReports()} and {@link ReportLocator#getUnapprovedReports()} instead")
    public final boolean isApproved(@NotNull String reportFileName) {
        Intrinsics.checkNotNullParameter((Object)reportFileName, (String)"reportFileName");
        return this.isSilent(reportFileName) || StringsKt.contains$default((CharSequence)reportFileName, (CharSequence)"-approved", (boolean)false, (int)2, null);
    }

    @NotNull
    public final Calendar getTimestamp(@NotNull String reportFileName) {
        Intrinsics.checkNotNullParameter((Object)reportFileName, (String)"reportFileName");
        String timestamp = StringsKt.replace$default((String)StringsKt.replace$default((String)reportFileName, (String)".stacktrace", (String)"", (boolean)false, (int)4, null), (String)ACRAConstants.SILENT_SUFFIX, (String)"", (boolean)false, (int)4, null);
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ", Locale.ENGLISH).parse(timestamp);
            Intrinsics.checkNotNull((Object)date);
            calendar.setTime(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"calendar");
        return calendar;
    }
}

