/*
 * Decompiled with CFR 0.152.
 */
package org.acra.data;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.builder.ReportBuilder;
import org.acra.collector.ApplicationStartupCollector;
import org.acra.collector.Collector;
import org.acra.collector.CollectorException;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/acra/data/CrashReportDataFactory;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "collectors", "", "Lorg/acra/collector/Collector;", "collectStartUp", "", "createCrashData", "Lorg/acra/data/CrashReportData;", "builder", "Lorg/acra/builder/ReportBuilder;", "acra-core_release"})
public final class CrashReportDataFactory {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final List<Collector> collectors;

    public CrashReportDataFactory(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        Iterable $this$sortedBy$iv = this.config.getPluginLoader().loadEnabled(this.config, Collector.class);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        this.collectors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                Collector.Order order;
                boolean bl = false;
                Collector it = (Collector)a;
                boolean bl2 = false;
                try {
                    order = it.getOrder();
                }
                catch (Exception t) {
                    order = Collector.Order.NORMAL;
                }
                it = (Collector)b;
                Comparable comparable = (Comparable)((Object)order);
                bl2 = false;
                try {
                    order = it.getOrder();
                }
                catch (Exception t) {
                    order = Collector.Order.NORMAL;
                }
                Collector.Order order2 = order;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)order2)));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CrashReportData createCrashData(@NotNull ReportBuilder builder) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ExecutorService executorService = this.config.getParallel() ? Executors.newCachedThreadPool() : Executors.newSingleThreadExecutor();
        CrashReportData crashReportData = new CrashReportData();
        Iterable $this$map$iv = this.collectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void collector;
            Collector collector2 = (Collector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Future<?> future = executorService.submit(() -> CrashReportDataFactory.createCrashData$lambda-6$lambda-5((Collector)collector, this, builder, crashReportData));
            collection.add(future);
        }
        List futures = (List)destination$iv$iv;
        block4: for (Future future : futures) {
            while (!future.isDone()) {
                try {
                    future.get();
                }
                catch (InterruptedException $this$mapTo$iv$iv2) {
                }
                catch (ExecutionException e) {
                    continue block4;
                }
            }
        }
        return crashReportData;
    }

    public final void collectStartUp() {
        for (Collector collector : this.collectors) {
            if (!(collector instanceof ApplicationStartupCollector)) continue;
            try {
                ((ApplicationStartupCollector)collector).collectApplicationStartUp(this.context, this.config);
            }
            catch (Throwable t) {
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = Intrinsics.stringPlus((String)collector.getClass().getSimpleName(), (Object)" failed to collect its startup data");
                aCRALog.w(string, string2, t);
            }
        }
    }

    private static final void createCrashData$lambda-6$lambda-5(Collector $collector, CrashReportDataFactory this$0, ReportBuilder $builder, CrashReportData $crashReportData) {
        Intrinsics.checkNotNullParameter((Object)$collector, (String)"$collector");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)$crashReportData, (String)"$crashReportData");
        try {
            String string;
            ACRALog aCRALog;
            String string2;
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = Intrinsics.stringPlus((String)"Calling collector ", (Object)$collector.getClass().getName());
                aCRALog.d(string2, string);
            }
            $collector.collect(this$0.context, this$0.config, $builder, $crashReportData);
            $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Collector " + $collector.getClass().getName() + " completed";
                aCRALog.d(string2, string);
            }
        }
        catch (CollectorException e) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "";
            aCRALog.w(string, string3, e);
        }
        catch (Throwable t) {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string4 = Intrinsics.stringPlus((String)"Error in collector ", (Object)$collector.getClass().getSimpleName());
            aCRALog.w(string, string4, t);
        }
    }
}

