/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010%\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010\r\u001a\u00020\u000eH\u0012\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\bH\u0012\u00a8\u0006+"}, d2={"Lorg/acra/collector/DisplayManagerCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "activeFlags", "", "flagNames", "Landroid/util/SparseArray;", "bitfield", "", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectCurrentSizeRange", "display", "Landroid/view/Display;", "container", "Lorg/json/JSONObject;", "collectDisplayData", "collectFlags", "collectIsValid", "collectMetrics", "metrics", "Landroid/util/DisplayMetrics;", "collectName", "collectRealMetrics", "collectRealSize", "collectRectSize", "collectRotation", "collectSize", "getDisplays", "", "(Landroid/content/Context;)[Landroid/view/Display;", "rotationToString", "rotation", "acra-core_release"})
@AutoService(value={Collector.class})
public class DisplayManagerCollector
extends BaseReportFieldCollector {
    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        JSONObject result = new JSONObject();
        for (Display display : this.getDisplays(context)) {
            try {
                result.put(String.valueOf(display.getDisplayId()), (Object)this.collectDisplayData(display));
            }
            catch (JSONException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Failed to collect data for display " + display.getDisplayId(), e);
            }
        }
        target.put(ReportField.DISPLAY, result);
    }

    private Display[] getDisplays(Context context) {
        Display[] displayArray;
        if (Build.VERSION.SDK_INT >= 17) {
            Object object = context.getSystemService("display");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
            }
            Display[] displayArray2 = ((DisplayManager)object).getDisplays();
            displayArray = displayArray2;
            Intrinsics.checkNotNullExpressionValue((Object)displayArray2, (String)"(context.getSystemServic\u2026 DisplayManager).displays");
        } else {
            Display[] displayArray3 = new Display[1];
            displayArray = displayArray3;
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            Display display = ((WindowManager)object).getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"(context.getSystemServic\u2026owManager).defaultDisplay");
            displayArray3[0] = display;
        }
        return displayArray;
    }

    private JSONObject collectDisplayData(Display display) throws JSONException {
        display.getMetrics(new DisplayMetrics());
        JSONObject result = new JSONObject();
        this.collectCurrentSizeRange(display, result);
        this.collectFlags(display, result);
        this.collectMetrics(display, result);
        this.collectRealMetrics(display, result);
        this.collectName(display, result);
        this.collectRealSize(display, result);
        this.collectRectSize(display, result);
        this.collectSize(display, result);
        this.collectRotation(display, result);
        this.collectIsValid(display, result);
        result.put("orientation", display.getRotation()).put("refreshRate", (double)display.getRefreshRate()).put("height", display.getHeight()).put("width", display.getWidth()).put("pixelFormat", display.getPixelFormat());
        return result;
    }

    private void collectIsValid(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            container.put("isValid", display.isValid());
        }
    }

    private void collectRotation(Display display, JSONObject container) throws JSONException {
        container.put("rotation", (Object)this.rotationToString(display.getRotation()));
    }

    private String rotationToString(int rotation) {
        String string;
        switch (rotation) {
            case 0: {
                string = "ROTATION_0";
                break;
            }
            case 1: {
                string = "ROTATION_90";
                break;
            }
            case 2: {
                string = "ROTATION_180";
                break;
            }
            case 3: {
                string = "ROTATION_270";
                break;
            }
            default: {
                string = String.valueOf(rotation);
            }
        }
        return string;
    }

    private void collectRectSize(Display display, JSONObject container) throws JSONException {
        Rect rect = new Rect();
        boolean bl = false;
        boolean bl2 = false;
        Rect it = rect;
        boolean bl3 = false;
        display.getRectSize(it);
        Rect size = rect;
        container.put("rectSize", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])new Integer[]{size.top, size.left, size.width(), size.height()})));
    }

    private void collectSize(Display display, JSONObject container) throws JSONException {
        Point point = new Point();
        boolean bl = false;
        boolean bl2 = false;
        Point it = point;
        boolean bl3 = false;
        display.getSize(it);
        Point size = point;
        container.put("size", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])new Integer[]{size.x, size.y})));
    }

    private void collectRealSize(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            Point point = new Point();
            boolean bl = false;
            boolean bl2 = false;
            Point it = point;
            boolean bl3 = false;
            display.getRealSize(it);
            Point size = point;
            container.put("realSize", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])new Integer[]{size.x, size.y})));
        }
    }

    private void collectCurrentSizeRange(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 16) {
            Point smallest = new Point();
            Point largest = new Point();
            display.getCurrentSizeRange(smallest, largest);
            JSONObject result = new JSONObject();
            result.put("smallest", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])new Integer[]{smallest.x, smallest.y})));
            result.put("largest", (Object)new JSONArray((Collection)CollectionsKt.listOf((Object[])new Integer[]{largest.x, largest.y})));
            container.put("currentSizeRange", (Object)result);
        }
    }

    private void collectFlags(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            SparseArray flagNames = new SparseArray();
            int flags = display.getFlags();
            Field[] fieldArray = display.getClass().getFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field;
                Field field2 = field = fieldArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
                String string = field2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                if (!StringsKt.startsWith$default((String)string, (String)"FLAG_", (boolean)false, (int)2, null)) continue;
                try {
                    flagNames.put(field.getInt(null), (Object)field.getName());
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            container.put("flags", (Object)this.activeFlags((SparseArray<String>)flagNames, flags));
        }
    }

    private void collectName(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            container.put("name", (Object)display.getName());
        }
    }

    private void collectMetrics(Display display, JSONObject container) throws JSONException {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        JSONObject result = new JSONObject();
        this.collectMetrics(metrics, result);
        container.put("metrics", (Object)result);
    }

    private void collectRealMetrics(Display display, JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            display.getRealMetrics(metrics);
            JSONObject result = new JSONObject();
            this.collectMetrics(metrics, result);
            container.put("realMetrics", (Object)result);
        }
    }

    private void collectMetrics(DisplayMetrics metrics, JSONObject container) throws JSONException {
        container.put("density", (double)metrics.density).put("densityDpi", metrics.densityDpi).put("scaledDensity", (Object)("x" + metrics.scaledDensity)).put("widthPixels", metrics.widthPixels).put("heightPixels", metrics.heightPixels).put("xdpi", (double)metrics.xdpi).put("ydpi", (double)metrics.ydpi);
    }

    /*
     * WARNING - void declaration
     */
    private String activeFlags(SparseArray<String> flagNames, int bitfield) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        int n2 = flagNames.size();
        while (n < n2) {
            void i;
            int maskValue = flagNames.keyAt((int)i);
            int value = bitfield & maskValue;
            if (value > 0) {
                CharSequence charSequence = result;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    result.append('+');
                }
                result.append((String)flagNames.get(value));
            }
            ++i;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    public DisplayManagerCollector() {
        super(ReportField.DISPLAY);
    }
}

