/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.config.CoreConfiguration;
import org.acra.scheduler.SenderScheduler;
import org.acra.sender.JobSenderService;
import org.acra.sender.LegacySenderService;
import org.acra.sender.SendingConductor;
import org.acra.util.BundleKt;
import org.acra.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0015J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/acra/scheduler/DefaultSenderScheduler;", "Lorg/acra/scheduler/SenderScheduler;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "configureExtras", "", "extras", "Landroid/os/Bundle;", "configureJob", "job", "Landroid/app/job/JobInfo$Builder;", "scheduleReportSending", "onlySendSilentReports", "", "acra-core_release"})
public class DefaultSenderScheduler
implements SenderScheduler {
    private final Context context;
    private final CoreConfiguration config;

    @Override
    public void scheduleReportSending(boolean onlySendSilentReports) {
        Bundle extras = new Bundle();
        extras.putString("acraConfig", IOUtils.INSTANCE.serialize(this.config));
        extras.putBoolean("onlySendSilentReports", onlySendSilentReports);
        this.configureExtras(extras);
        SendingConductor conductor = new SendingConductor(this.context, this.config);
        Collection collection = conductor.getSenderInstances(false);
        boolean bl = false;
        if (!collection.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 22) {
                JobInfo.Builder builder;
                Object object = this.context.getSystemService("jobscheduler");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
                }
                JobScheduler scheduler = (JobScheduler)object;
                JobInfo.Builder builder2 = builder = new JobInfo.Builder(0, new ComponentName(this.context, JobSenderService.class)).setExtras(BundleKt.toPersistableBundle(extras));
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
                this.configureJob(builder2);
                scheduler.schedule(builder.build());
            } else {
                Intent intent = new Intent();
                intent.putExtras(extras);
                intent.setComponent(new ComponentName(this.context, LegacySenderService.class));
                this.context.startService(intent);
            }
        }
        collection = conductor.getSenderInstances(true);
        bl = false;
        if (!collection.isEmpty()) {
            conductor.sendReports(true, extras);
        }
    }

    @RequiresApi(api=21)
    protected void configureJob(@NotNull JobInfo.Builder job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        job.setOverrideDeadline(0L);
    }

    protected final void configureExtras(@NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
    }

    public DefaultSenderScheduler(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
    }
}

