/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.os.Build;
import com.google.auto.service.AutoService;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.collector.SimpleValuesCollector$WhenMappings;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.util.Installation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0012J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/acra/collector/SimpleValuesCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "getApplicationFilePath", "", "shouldCollect", "", "Companion", "acra-core_release"})
@AutoService(value={Collector.class})
public class SimpleValuesCollector
extends BaseReportFieldCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (SimpleValuesCollector$WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                target.put(ReportField.IS_SILENT, reportBuilder.isSendSilently());
                break;
            }
            case 2: {
                target.put(ReportField.REPORT_ID, UUID.randomUUID().toString());
                break;
            }
            case 3: {
                target.put(ReportField.INSTALLATION_ID, Installation.id(context));
                break;
            }
            case 4: {
                target.put(ReportField.PACKAGE_NAME, context.getPackageName());
                break;
            }
            case 5: {
                target.put(ReportField.PHONE_MODEL, Build.MODEL);
                break;
            }
            case 6: {
                target.put(ReportField.ANDROID_VERSION, Build.VERSION.RELEASE);
                break;
            }
            case 7: {
                target.put(ReportField.BRAND, Build.BRAND);
                break;
            }
            case 8: {
                target.put(ReportField.PRODUCT, Build.PRODUCT);
                break;
            }
            case 9: {
                target.put(ReportField.FILE_PATH, this.getApplicationFilePath(context));
                break;
            }
            case 10: {
                target.put(ReportField.USER_IP, SimpleValuesCollector.Companion.getLocalIpAddress());
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)collect, (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return collect == ReportField.IS_SILENT || collect == ReportField.REPORT_ID || super.shouldCollect(context, config, collect, reportBuilder);
    }

    private String getApplicationFilePath(Context context) {
        File file = context.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.filesDir");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.filesDir.absolutePath");
        return string;
    }

    public SimpleValuesCollector() {
        super(ReportField.IS_SILENT, ReportField.REPORT_ID, ReportField.INSTALLATION_ID, ReportField.PACKAGE_NAME, ReportField.PHONE_MODEL, ReportField.ANDROID_VERSION, ReportField.BRAND, ReportField.PRODUCT, ReportField.FILE_PATH, ReportField.USER_IP);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lorg/acra/collector/SimpleValuesCollector$Companion;", "", "()V", "getLocalIpAddress", "", "acra-core_release"})
    public static final class Companion {
        private final String getLocalIpAddress() throws SocketException {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf;
                NetworkInterface networkInterface = intf = en.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"intf");
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress;
                    InetAddress inetAddress2 = inetAddress = enumIpAddr.nextElement();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"inetAddress");
                    if (inetAddress2.isLoopbackAddress()) continue;
                    if (!first) {
                        result.append('\n');
                    }
                    result.append(inetAddress.getHostAddress());
                    first = false;
                }
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

