/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.os.Build;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.collector.LogCatCollector$WhenMappings;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.StreamReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0012J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0018\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/acra/collector/LogCatCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectLogCat", "", "bufferName", "shouldCollect", "", "streamToString", "input", "Ljava/io/InputStream;", "filter", "Lkotlin/Function1;", "limit", "", "Companion", "acra-core_release"})
@AutoService(value={Collector.class})
public class LogCatCollector
extends BaseReportFieldCollector {
    private static final int READ_TIMEOUT = 3000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.FIRST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String collectLogCat(CoreConfiguration config, String bufferName) throws IOException {
        String string;
        Object object;
        Object object2;
        Object object3;
        int n;
        int myPid = android.os.Process.myPid();
        String myPidStr = Build.VERSION.SDK_INT < 16 && config.getLogcatFilterByPid() && myPid > 0 ? myPid + "):" : null;
        List commandLine = new ArrayList();
        commandLine.add("logcat");
        if (bufferName != null) {
            commandLine.add("-b");
            commandLine.add(bufferName);
        }
        int tailCount = 0;
        List logcatArgumentsList = ArraysKt.toList((Object[])config.getLogcatArguments());
        int tailIndex = logcatArgumentsList.indexOf("-t");
        if (tailIndex > -1 && tailIndex < logcatArgumentsList.size()) {
            String string2 = (String)logcatArgumentsList.get(tailIndex + 1);
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = -1;
        }
        tailCount = n;
        commandLine.addAll(logcatArgumentsList);
        Process process = new ProcessBuilder(new String[0]).command(commandLine).redirectErrorStream(true).start();
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            object3 = ACRA.LOG_TAG;
            object2 = ACRA.log;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Retrieving logcat output (buffer:");
            String string3 = bufferName;
            if (string3 == null) {
                string3 = "default";
            }
            object = stringBuilder.append(string3).append(")...").toString();
            object2.d((String)object3, (String)object);
        }
        try {
            Function1 function1;
            Object object4 = this;
            Object object5 = config;
            Process process2 = process;
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            InputStream inputStream = process2.getInputStream();
            Object object6 = inputStream;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            String string4 = myPidStr;
            if (string4 != null) {
                void pid;
                String string5 = string4;
                boolean bl = false;
                boolean bl2 = false;
                String string6 = string5;
                object = object6;
                object3 = object5;
                object2 = object4;
                boolean bl3 = false;
                Function1 function12 = (Function1)new Function1<String, Boolean>((String)pid){
                    final /* synthetic */ String $pid;

                    public final boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return StringsKt.contains$default((CharSequence)it, (CharSequence)this.$pid, (boolean)false, (int)2, null);
                    }
                    {
                        this.$pid = string;
                        super(1);
                    }
                };
                object4 = object2;
                object5 = object3;
                object6 = object;
                function1 = function12;
            } else {
                function1 = null;
            }
            string = ((LogCatCollector)object4).streamToString((CoreConfiguration)object5, (InputStream)object6, function1, tailCount);
        }
        finally {
            process.destroy();
        }
        return string;
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)collect, (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && (Build.VERSION.SDK_INT >= 16 || new PackageManagerWrapper(context).hasPermission("android.permission.READ_LOGS")) && new SharedPreferencesFactory(context, config).create().getBoolean("acra.syslog.enable", true);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String bufferName = null;
        switch (LogCatCollector$WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                bufferName = null;
                break;
            }
            case 2: {
                bufferName = "events";
                break;
            }
            case 3: {
                bufferName = "radio";
                break;
            }
        }
        target.put(reportField, this.collectLogCat(config, bufferName));
    }

    private String streamToString(CoreConfiguration config, InputStream input, Function1<? super String, Boolean> filter, int limit) throws IOException {
        StreamReader reader = new StreamReader(input, 0, 0, null, 14, null).setFilter(filter).setLimit(limit);
        if (config.getLogcatReadNonBlocking()) {
            reader.setTimeout(3000);
        }
        return reader.read();
    }

    public LogCatCollector() {
        super(ReportField.LOGCAT, ReportField.EVENTSLOG, ReportField.RADIOLOG);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/acra/collector/LogCatCollector$Companion;", "", "()V", "READ_TIMEOUT", "", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

