/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.config.Configuration;
import org.acra.config.CoreConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00040\tH\u0007\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/acra/config/ConfigUtils;", "", "()V", "getPluginConfiguration", "T", "Lorg/acra/config/Configuration;", "config", "Lorg/acra/config/CoreConfiguration;", "c", "Ljava/lang/Class;", "(Lorg/acra/config/CoreConfiguration;Ljava/lang/Class;)Lorg/acra/config/Configuration;", "acra-core_release"})
public final class ConfigUtils {
    @NotNull
    public static final ConfigUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final <T extends Configuration> T getPluginConfiguration(@NotNull CoreConfiguration config, @NotNull Class<T> c) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Checking plugin Configurations : " + config.getPluginConfigurations().toString() + " for class : " + c);
        }
        for (Configuration configuration : config.getPluginConfigurations()) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Checking plugin Configuration : " + configuration + " against plugin class : " + c);
            }
            if (!c.isAssignableFrom(configuration.getClass())) continue;
            Configuration configuration2 = configuration;
            if (configuration2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type T");
            }
            return (T)configuration2;
        }
        throw (Throwable)new IllegalArgumentException(c.getName() + " is no registered configuration");
    }

    private ConfigUtils() {
    }

    static {
        ConfigUtils configUtils;
        INSTANCE = configUtils = new ConfigUtils();
    }
}

