/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.Process;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.builder.LastActivityManager;
import org.acra.config.CoreConfiguration;
import org.acra.log.ACRALog;
import org.acra.sender.JobSenderService;
import org.acra.sender.LegacySenderService;
import org.acra.util.SystemServices;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/acra/util/ProcessFinisher;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "lastActivityManager", "Lorg/acra/builder/LastActivityManager;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;Lorg/acra/builder/LastActivityManager;)V", "endApplication", "", "finishLastActivity", "uncaughtExceptionThread", "Ljava/lang/Thread;", "killProcessAndExit", "stopServices", "acra-core_release"})
public final class ProcessFinisher {
    private final Context context;
    private final CoreConfiguration config;
    private final LastActivityManager lastActivityManager;

    public final void endApplication() {
        this.stopServices();
        this.killProcessAndExit();
    }

    public final void finishLastActivity(@Nullable Thread uncaughtExceptionThread) {
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Finishing activities prior to killing the Process";
            aCRALog.d(string, string2);
        }
        boolean wait = false;
        for (Activity activity : this.lastActivityManager.getLastActivities()) {
            Runnable finisher2 = new Runnable(activity){
                final /* synthetic */ Activity $activity;

                public final void run() {
                    this.$activity.finish();
                    boolean $i$f$debug = false;
                    if (ACRA.DEV_LOGGING) {
                        String string = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl = false;
                        String string2 = "Finished " + this.$activity.getClass();
                        aCRALog.d(string, string2);
                    }
                }
                {
                    this.$activity = activity;
                }
            };
            Looper looper = activity.getMainLooper();
            Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"activity.mainLooper");
            if (uncaughtExceptionThread == looper.getThread()) {
                finisher2.run();
                continue;
            }
            wait = true;
            activity.runOnUiThread(finisher2);
        }
        if (wait) {
            this.lastActivityManager.waitForAllActivitiesDestroy(100);
        }
        this.lastActivityManager.clearLastActivities();
    }

    private final void stopServices() {
        if (this.config.getStopServicesOnCrash()) {
            try {
                ActivityManager activityManager = SystemServices.getActivityManager(this.context);
                List runningServices = activityManager.getRunningServices(Integer.MAX_VALUE);
                int pid = Process.myPid();
                for (ActivityManager.RunningServiceInfo serviceInfo : runningServices) {
                    if (serviceInfo.pid != pid) continue;
                    String string = LegacySenderService.class.getName();
                    ComponentName componentName = serviceInfo.service;
                    Intrinsics.checkNotNullExpressionValue((Object)componentName, (String)"serviceInfo.service");
                    if (!(Intrinsics.areEqual((Object)string, (Object)componentName.getClassName()) ^ true)) continue;
                    String string2 = JobSenderService.class.getName();
                    ComponentName componentName2 = serviceInfo.service;
                    Intrinsics.checkNotNullExpressionValue((Object)componentName2, (String)"serviceInfo.service");
                    if (!(Intrinsics.areEqual((Object)string2, (Object)componentName2.getClassName()) ^ true)) continue;
                    try {
                        Intent intent = new Intent();
                        intent.setComponent(serviceInfo.service);
                        this.context.stopService(intent);
                    }
                    catch (SecurityException e) {
                        boolean $i$f$debug = false;
                        if (!ACRA.DEV_LOGGING) continue;
                        String string3 = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl = false;
                        StringBuilder stringBuilder = new StringBuilder().append("Unable to stop Service ");
                        ComponentName componentName3 = serviceInfo.service;
                        Intrinsics.checkNotNullExpressionValue((Object)componentName3, (String)"serviceInfo.service");
                        String string4 = stringBuilder.append(componentName3.getClassName()).append(". Permission denied").toString();
                        aCRALog.d(string3, string4);
                    }
                }
            }
            catch (SystemServices.ServiceNotReachedException e) {
                boolean $i$f$error = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string5 = "Unable to stop services";
                aCRALog.e(string, string5, e);
            }
        }
    }

    private final void killProcessAndExit() {
        Process.killProcess((int)Process.myPid());
        int n = 10;
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    public ProcessFinisher(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull LastActivityManager lastActivityManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)lastActivityManager, (String)"lastActivityManager");
        this.context = context;
        this.config = config;
        this.lastActivityManager = lastActivityManager;
    }
}

