/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.content.Context;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.ReportLocator;
import org.acra.log.ACRALog;
import org.acra.plugins.PluginLoader;
import org.acra.scheduler.DefaultSenderScheduler;
import org.acra.scheduler.SenderScheduler;
import org.acra.scheduler.SenderSchedulerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/acra/scheduler/SchedulerStarter;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "locator", "Lorg/acra/file/ReportLocator;", "senderScheduler", "Lorg/acra/scheduler/SenderScheduler;", "getSenderScheduler", "()Lorg/acra/scheduler/SenderScheduler;", "scheduleReports", "", "report", "Ljava/io/File;", "onlySendSilentReports", "", "acra-core_release"})
public final class SchedulerStarter {
    private final ReportLocator locator;
    @NotNull
    private final SenderScheduler senderScheduler;

    @NotNull
    public final SenderScheduler getSenderScheduler() {
        return this.senderScheduler;
    }

    public final void scheduleReports(@Nullable File report, boolean onlySendSilentReports) {
        String string;
        ACRALog aCRALog;
        String string2;
        if (report != null) {
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Mark " + report.getName() + " as approved.";
                aCRALog.d(string2, string);
            }
            File approvedReport = new File(this.locator.getApprovedFolder(), report.getName());
            if (!report.renameTo(approvedReport)) {
                boolean $i$f$warn = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Could not rename approved report from " + report + " to " + approvedReport;
                aCRALog.w(string2, string);
            }
        }
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "Schedule report sending";
            aCRALog.d(string2, string);
        }
        this.senderScheduler.scheduleReportSending(onlySendSilentReports);
    }

    public SchedulerStarter(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.locator = new ReportLocator(context);
        PluginLoader $this$loadEnabled$iv = config.getPluginLoader();
        boolean $i$f$loadEnabled = false;
        List<SenderSchedulerFactory> schedulerFactories = $this$loadEnabled$iv.loadEnabled(config, SenderSchedulerFactory.class);
        if (schedulerFactories.isEmpty()) {
            this.senderScheduler = new DefaultSenderScheduler(context, config);
        } else {
            this.senderScheduler = schedulerFactories.get(0).create(context, config);
            if (schedulerFactories.size() > 1) {
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "More than one SenderScheduler found. Will use only " + this.senderScheduler.getClass().getSimpleName();
                aCRALog.w(string, string2);
            }
        }
    }
}

