/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.SettingsCollector$WhenMappings;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0012J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0012\u00a8\u0006\u0018"}, d2={"Lorg/acra/collector/SettingsCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectSettings", "Lorg/json/JSONObject;", "settings", "Ljava/lang/Class;", "isAuthorized", "", "key", "Ljava/lang/reflect/Field;", "Companion", "acra-core_release"})
public class SettingsCollector
extends BaseReportFieldCollector {
    private static final String ERROR = "Error: ";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (SettingsCollector$WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                target.put(ReportField.SETTINGS_SYSTEM, this.collectSettings(context, config, Settings.System.class));
                break;
            }
            case 2: {
                target.put(ReportField.SETTINGS_SECURE, this.collectSettings(context, config, Settings.Secure.class));
                break;
            }
            case 3: {
                target.put(ReportField.SETTINGS_GLOBAL, Build.VERSION.SDK_INT >= 17 ? this.collectSettings(context, config, Settings.Global.class) : null);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
    }

    private JSONObject collectSettings(Context context, CoreConfiguration config, Class<?> settings) throws NoSuchMethodException {
        JSONObject result = new JSONObject();
        Field[] keys = settings.getFields();
        Method getString = settings.getMethod("getString", ContentResolver.class, String.class);
        for (Field key : keys) {
            if (key.isAnnotationPresent(Deprecated.class)) continue;
            Field field = key;
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"key");
            if (!Intrinsics.areEqual(field.getType(), String.class) || !this.isAuthorized(config, key)) continue;
            try {
                Object value = getString.invoke(null, context.getContentResolver(), key.get(null));
                if (value == null) continue;
                result.put(key.getName(), value);
            }
            catch (Exception e) {
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = ERROR;
                aCRALog.w(string, string2, e);
            }
        }
        return result;
    }

    private boolean isAuthorized(CoreConfiguration config, Field key) {
        block4: {
            block3: {
                if (key == null) break block3;
                String string = key.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.name");
                if (!StringsKt.startsWith$default((String)string, (String)"WIFI_AP", (boolean)false, (int)2, null)) break block4;
            }
            return false;
        }
        for (String regex : config.getExcludeMatchingSettingsKeys()) {
            String string = key.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.name");
            CharSequence charSequence = string;
            Regex regex2 = new Regex(regex);
            boolean bl = false;
            if (!regex2.matches(charSequence)) continue;
            return false;
        }
        return true;
    }

    public SettingsCollector() {
        super(ReportField.SETTINGS_SYSTEM, ReportField.SETTINGS_SECURE, ReportField.SETTINGS_GLOBAL);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/acra/collector/SettingsCollector$Companion;", "", "()V", "ERROR", "", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

