/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedList;
import org.acra.collections.BoundedLinkedList;
import org.acra.util.IOUtils;
import org.acra.util.Predicate;

public class StreamReader {
    private static final int NO_LIMIT = -1;
    private static final int INDEFINITE = -1;
    private final InputStream inputStream;
    private int limit = -1;
    private int timeout = -1;
    private Predicate<String> filter = null;

    public StreamReader(@NonNull String filename) throws FileNotFoundException {
        this(new File(filename));
    }

    public StreamReader(@NonNull File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public StreamReader(@NonNull InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @NonNull
    public StreamReader setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @NonNull
    public StreamReader setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @NonNull
    public StreamReader setFilter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    @NonNull
    public String read() throws IOException {
        String text;
        String string = text = this.timeout == -1 ? this.readFully() : this.readWithTimeout();
        if (this.filter == null) {
            if (this.limit == -1) {
                return text;
            }
            String[] lines = text.split("\\r?\\n");
            if (lines.length <= this.limit) {
                return text;
            }
            return TextUtils.join((CharSequence)"\n", (Object[])Arrays.copyOfRange(lines, lines.length - this.limit, lines.length));
        }
        String[] lines = text.split("\\r?\\n");
        LinkedList<String> buffer = this.limit == -1 ? new LinkedList<String>() : new BoundedLinkedList(this.limit);
        for (String line : lines) {
            if (!this.filter.apply(line)) continue;
            buffer.add(line);
        }
        return TextUtils.join((CharSequence)"\n", buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private String readFully() throws IOException {
        InputStreamReader input = new InputStreamReader(this.inputStream);
        try {
            int count;
            StringWriter output = new StringWriter();
            char[] buffer = new char[8192];
            while ((count = input.read(buffer)) != -1) {
                output.write(buffer, 0, count);
            }
            String string = output.toString();
            return string;
        }
        finally {
            IOUtils.safeClose(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private String readWithTimeout() throws IOException {
        long until = System.currentTimeMillis() + (long)this.timeout;
        try {
            int count;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((count = this.fillBufferUntil(buffer, until)) != -1) {
                output.write(buffer, 0, count);
            }
            String string = output.toString();
            return string;
        }
        finally {
            IOUtils.safeClose(this.inputStream);
        }
    }

    private int fillBufferUntil(@NonNull byte[] buffer, long until) throws IOException {
        int bufferOffset;
        int readResult;
        for (bufferOffset = 0; System.currentTimeMillis() < until && bufferOffset < buffer.length && (readResult = this.inputStream.read(buffer, bufferOffset, Math.min(this.inputStream.available(), buffer.length - bufferOffset))) != -1; bufferOffset += readResult) {
        }
        return bufferOffset;
    }
}

