/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.res.Configuration;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.ApplicationStartupCollector;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.json.JSONException;
import org.json.JSONObject;

public final class ConfigurationCollector
extends BaseReportFieldCollector
implements ApplicationStartupCollector {
    private static final String SUFFIX_MASK = "_MASK";
    private static final String FIELD_SCREENLAYOUT = "screenLayout";
    private static final String FIELD_UIMODE = "uiMode";
    private static final String FIELD_MNC = "mnc";
    private static final String FIELD_MCC = "mcc";
    private static final String PREFIX_UI_MODE = "UI_MODE_";
    private static final String PREFIX_TOUCHSCREEN = "TOUCHSCREEN_";
    private static final String PREFIX_SCREENLAYOUT = "SCREENLAYOUT_";
    private static final String PREFIX_ORIENTATION = "ORIENTATION_";
    private static final String PREFIX_NAVIGATIONHIDDEN = "NAVIGATIONHIDDEN_";
    private static final String PREFIX_NAVIGATION = "NAVIGATION_";
    private static final String PREFIX_KEYBOARDHIDDEN = "KEYBOARDHIDDEN_";
    private static final String PREFIX_KEYBOARD = "KEYBOARD_";
    private static final String PREFIX_HARDKEYBOARDHIDDEN = "HARDKEYBOARDHIDDEN_";
    private JSONObject initialConfiguration;

    public ConfigurationCollector() {
        super(ReportField.INITIAL_CONFIGURATION, ReportField.CRASH_CONFIGURATION);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) {
        switch (reportField) {
            case INITIAL_CONFIGURATION: {
                target.put(ReportField.INITIAL_CONFIGURATION, this.initialConfiguration);
                break;
            }
            case CRASH_CONFIGURATION: {
                target.put(ReportField.CRASH_CONFIGURATION, this.collectConfiguration(context));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void collectApplicationStartUp(@NonNull Context context, @NonNull CoreConfiguration config) {
        if (config.reportContent().contains((Object)ReportField.INITIAL_CONFIGURATION)) {
            this.initialConfiguration = this.collectConfiguration(context);
        }
    }

    @NonNull
    private JSONObject configToJson(@NonNull Configuration conf) {
        JSONObject result = new JSONObject();
        Map<String, SparseArray<String>> valueArrays = this.getValueArrays();
        for (Field f : conf.getClass().getFields()) {
            try {
                if (Modifier.isStatic(f.getModifiers())) continue;
                String fieldName = f.getName();
                try {
                    if (f.getType().equals(Integer.TYPE)) {
                        result.put(fieldName, this.getFieldValueName(valueArrays, conf, f));
                        continue;
                    }
                    if (f.get(conf) == null) continue;
                    result.put(fieldName, f.get(conf));
                }
                catch (JSONException e) {
                    ACRA.log.w(ACRA.LOG_TAG, "Could not collect configuration field " + fieldName, e);
                }
            }
            catch (IllegalArgumentException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Error while inspecting device configuration: ", e);
            }
            catch (IllegalAccessException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Error while inspecting device configuration: ", e);
            }
        }
        return result;
    }

    @NonNull
    private Map<String, SparseArray<String>> getValueArrays() {
        HashMap<String, SparseArray<String>> valueArrays = new HashMap<String, SparseArray<String>>();
        SparseArray hardKeyboardHiddenValues = new SparseArray();
        SparseArray keyboardValues = new SparseArray();
        SparseArray keyboardHiddenValues = new SparseArray();
        SparseArray navigationValues = new SparseArray();
        SparseArray navigationHiddenValues = new SparseArray();
        SparseArray orientationValues = new SparseArray();
        SparseArray screenLayoutValues = new SparseArray();
        SparseArray touchScreenValues = new SparseArray();
        SparseArray uiModeValues = new SparseArray();
        for (Field f : Configuration.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
            String fieldName = f.getName();
            try {
                if (fieldName.startsWith(PREFIX_HARDKEYBOARDHIDDEN)) {
                    hardKeyboardHiddenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_KEYBOARD)) {
                    keyboardValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_KEYBOARDHIDDEN)) {
                    keyboardHiddenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_NAVIGATION)) {
                    navigationValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_NAVIGATIONHIDDEN)) {
                    navigationHiddenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_ORIENTATION)) {
                    orientationValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_SCREENLAYOUT)) {
                    screenLayoutValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_TOUCHSCREEN)) {
                    touchScreenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (!fieldName.startsWith(PREFIX_UI_MODE)) continue;
                uiModeValues.put(f.getInt(null), (Object)fieldName);
            }
            catch (IllegalArgumentException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while inspecting device configuration: ", e);
            }
            catch (IllegalAccessException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while inspecting device configuration: ", e);
            }
        }
        valueArrays.put(PREFIX_HARDKEYBOARDHIDDEN, hardKeyboardHiddenValues);
        valueArrays.put(PREFIX_KEYBOARD, keyboardValues);
        valueArrays.put(PREFIX_KEYBOARDHIDDEN, keyboardHiddenValues);
        valueArrays.put(PREFIX_NAVIGATION, navigationValues);
        valueArrays.put(PREFIX_NAVIGATIONHIDDEN, navigationHiddenValues);
        valueArrays.put(PREFIX_ORIENTATION, orientationValues);
        valueArrays.put(PREFIX_SCREENLAYOUT, screenLayoutValues);
        valueArrays.put(PREFIX_TOUCHSCREEN, touchScreenValues);
        valueArrays.put(PREFIX_UI_MODE, uiModeValues);
        return valueArrays;
    }

    private Object getFieldValueName(@NonNull Map<String, SparseArray<String>> valueArrays, @NonNull Configuration conf, @NonNull Field f) throws IllegalAccessException {
        String fieldName;
        switch (fieldName = f.getName()) {
            case "mcc": 
            case "mnc": {
                return f.getInt(conf);
            }
            case "uiMode": {
                return this.activeFlags(valueArrays.get(PREFIX_UI_MODE), f.getInt(conf));
            }
            case "screenLayout": {
                return this.activeFlags(valueArrays.get(PREFIX_SCREENLAYOUT), f.getInt(conf));
            }
        }
        SparseArray<String> values = valueArrays.get(fieldName.toUpperCase() + '_');
        if (values == null) {
            return f.getInt(conf);
        }
        String value = (String)values.get(f.getInt(conf));
        if (value == null) {
            return f.getInt(conf);
        }
        return value;
    }

    @NonNull
    private String activeFlags(@NonNull SparseArray<String> valueNames, int bitfield) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < valueNames.size(); ++i) {
            int value;
            int maskValue = valueNames.keyAt(i);
            if (!((String)valueNames.get(maskValue)).endsWith(SUFFIX_MASK) || (value = bitfield & maskValue) <= 0) continue;
            if (result.length() > 0) {
                result.append('+');
            }
            result.append((String)valueNames.get(value));
        }
        return result.toString();
    }

    @Nullable
    private JSONObject collectConfiguration(@NonNull Context context) {
        try {
            return this.configToJson(context.getResources().getConfiguration());
        }
        catch (RuntimeException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Couldn't retrieve CrashConfiguration for : " + context.getPackageName(), e);
            return null;
        }
    }
}

