/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import org.acra.ErrorReporter;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.CoreConfiguration;
import org.acra.config.CoreConfigurationBuilder;
import org.acra.legacy.LegacyFileHandler;
import org.acra.log.ACRALog;
import org.acra.log.AndroidLogDelegate;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.reporter.ErrorReporterImpl;
import org.acra.util.StreamReader;
import org.acra.util.StubCreator;

@Keep
public final class ACRA {
    public static boolean DEV_LOGGING = false;
    public static final String LOG_TAG = ACRA.class.getSimpleName();
    @NonNull
    public static ACRALog log = new AndroidLogDelegate();
    private static final String ACRA_PRIVATE_PROCESS_NAME = ":acra";
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    public static final String PREF_ENABLE_SYSTEM_LOGS = "acra.syslog.enable";
    public static final String PREF_ENABLE_DEVICE_ID = "acra.deviceid.enable";
    public static final String PREF_USER_EMAIL_ADDRESS = "acra.user.email";
    public static final String PREF_ALWAYS_ACCEPT = "acra.alwaysaccept";
    public static final String PREF_LAST_VERSION_NR = "acra.lastVersionNr";
    @NonNull
    private static ErrorReporter errorReporterSingleton = StubCreator.createErrorReporterStub();

    private ACRA() {
    }

    public static void init(@NonNull Application app) {
        ACRA.init(app, new CoreConfigurationBuilder((Context)app));
    }

    public static void init(@NonNull Application app, @NonNull CoreConfigurationBuilder builder) {
        ACRA.init(app, builder, true);
    }

    public static void init(@NonNull Application app, @NonNull CoreConfigurationBuilder builder, boolean checkReportsOnApplicationStart) {
        try {
            ACRA.init(app, builder.build(), checkReportsOnApplicationStart);
        }
        catch (ACRAConfigurationException e) {
            log.w(LOG_TAG, "Configuration Error - ACRA not started : " + e.getMessage());
        }
    }

    public static void init(@NonNull Application app, @NonNull CoreConfiguration config) {
        ACRA.init(app, config, true);
    }

    public static void init(@NonNull Application app, @NonNull CoreConfiguration config, boolean checkReportsOnApplicationStart) {
        boolean supportedAndroidVersion;
        boolean senderServiceProcess = ACRA.isACRASenderServiceProcess();
        if (senderServiceProcess && DEV_LOGGING) {
            log.d(LOG_TAG, "Not initialising ACRA to listen for uncaught Exceptions as this is the SendWorker process and we only send reports, we don't capture them to avoid infinite loops");
        }
        boolean bl = supportedAndroidVersion = Build.VERSION.SDK_INT >= 14;
        if (!supportedAndroidVersion) {
            log.w(LOG_TAG, "ACRA 5.1.0+ requires ICS or greater. ACRA is disabled and will NOT catch crashes or send messages.");
        }
        if (ACRA.isInitialised()) {
            log.w(LOG_TAG, "ACRA#init called more than once. This might have unexpected side effects. Doing this outside of tests is discouraged.");
            if (DEV_LOGGING) {
                log.d(LOG_TAG, "Removing old ACRA config...");
            }
            ((ErrorReporterImpl)errorReporterSingleton).unregister();
            errorReporterSingleton = StubCreator.createErrorReporterStub();
        }
        if (config == null) {
            log.e(LOG_TAG, "ACRA#init called but no CoreConfiguration provided");
            return;
        }
        SharedPreferences prefs = new SharedPreferencesFactory((Context)app, config).create();
        new LegacyFileHandler((Context)app, prefs).updateToCurrentVersionIfNecessary();
        if (!senderServiceProcess) {
            boolean enableAcra = supportedAndroidVersion && SharedPreferencesFactory.shouldEnableACRA(prefs);
            log.i(LOG_TAG, "ACRA is " + (enableAcra ? "enabled" : "disabled") + " for " + app.getPackageName() + ", initializing...");
            ErrorReporterImpl reporter = new ErrorReporterImpl(app, config, enableAcra, supportedAndroidVersion, checkReportsOnApplicationStart);
            errorReporterSingleton = reporter;
            prefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)reporter);
        }
    }

    public static boolean isInitialised() {
        return errorReporterSingleton instanceof ErrorReporterImpl;
    }

    public static boolean isACRASenderServiceProcess() {
        String processName = ACRA.getCurrentProcessName();
        if (DEV_LOGGING) {
            log.d(LOG_TAG, "ACRA processName='" + processName + '\'');
        }
        return processName != null && processName.endsWith(ACRA_PRIVATE_PROCESS_NAME);
    }

    @Nullable
    private static String getCurrentProcessName() {
        try {
            return new StreamReader("/proc/self/cmdline").read().trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    @NonNull
    public static ErrorReporter getErrorReporter() {
        return errorReporterSingleton;
    }

    public static void setLog(@NonNull ACRALog log) {
        if (log == null) {
            throw new NullPointerException("ACRALog cannot be null");
        }
        ACRA.log = log;
    }
}

