/*
 * Decompiled with CFR 0.152.
 */
package org.acra.plugins;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.plugins.Plugin;
import org.acra.plugins.PluginLoader;
import org.acra.util.Predicate;

public class ServicePluginLoader
implements PluginLoader {
    @Override
    public <T extends Plugin> List<T> load(@NonNull Class<T> clazz) {
        return this.loadInternal(clazz, plugin -> true);
    }

    @Override
    public <T extends Plugin> List<T> loadEnabled(@NonNull CoreConfiguration config, @NonNull Class<T> clazz) {
        return this.loadInternal(clazz, plugin -> plugin.enabled(config));
    }

    private <T extends Plugin> List<T> loadInternal(@NonNull Class<T> clazz, Predicate<T> shouldLoadPredicate) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, this.getClass().getClassLoader());
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "ServicePluginLoader loading services from ServiceLoader : " + serviceLoader);
        }
        Iterator<T> iterator = serviceLoader.iterator();
        while (true) {
            block9: {
                try {
                    if (!iterator.hasNext()) {
                    }
                    break block9;
                }
                catch (ServiceConfigurationError e) {
                    ACRA.log.e(ACRA.LOG_TAG, "Broken ServiceLoader for " + clazz.getSimpleName(), e);
                }
                break;
            }
            try {
                Plugin plugin = (Plugin)iterator.next();
                if (shouldLoadPredicate.apply(plugin)) {
                    if (ACRA.DEV_LOGGING) {
                        ACRA.log.d(ACRA.LOG_TAG, "Loaded " + clazz.getSimpleName() + " of type " + plugin.getClass().getName());
                    }
                    plugins.add(plugin);
                    continue;
                }
                if (!ACRA.DEV_LOGGING) continue;
                ACRA.log.d(ACRA.LOG_TAG, "Ignoring disabled " + clazz.getSimpleName() + " of type " + plugin.getClass().getSimpleName());
            }
            catch (ServiceConfigurationError e) {
                ACRA.log.e(ACRA.LOG_TAG, "Unable to load " + clazz.getSimpleName(), e);
            }
        }
        return plugins;
    }
}

