/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import androidx.annotation.NonNull;
import org.acra.ACRA;
import org.acra.config.Configuration;
import org.acra.config.CoreConfiguration;

public final class ConfigUtils {
    @NonNull
    public static <T extends Configuration> T getPluginConfiguration(@NonNull CoreConfiguration config, @NonNull Class<T> c) {
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Checking plugin Configurations : " + config.pluginConfigurations() + " for class : " + c);
        }
        for (Configuration configuration : config.pluginConfigurations()) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Checking plugin Configuration : " + configuration + " against plugin class : " + c);
            }
            if (!c.isAssignableFrom(configuration.getClass())) continue;
            return (T)configuration;
        }
        throw new IllegalArgumentException(c.getName() + " is no registered configuration");
    }
}

