/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.json.JSONException;
import org.json.JSONObject;

public final class SharedPreferencesCollector
extends BaseReportFieldCollector {
    public SharedPreferencesCollector() {
        super(ReportField.USER_EMAIL, ReportField.SHARED_PREFERENCES);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws Exception {
        switch (reportField) {
            case USER_EMAIL: {
                target.put(ReportField.USER_EMAIL, new SharedPreferencesFactory(context, config).create().getString("acra.user.email", null));
                break;
            }
            case SHARED_PREFERENCES: {
                target.put(ReportField.SHARED_PREFERENCES, this.collect(context, config));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @NonNull
    private JSONObject collect(@NonNull Context context, @NonNull CoreConfiguration config) throws JSONException {
        JSONObject result = new JSONObject();
        TreeMap<String, SharedPreferences> sharedPrefs = new TreeMap<String, SharedPreferences>();
        sharedPrefs.put("default", PreferenceManager.getDefaultSharedPreferences((Context)context));
        for (String sharedPrefId : config.additionalSharedPreferences()) {
            sharedPrefs.put(sharedPrefId, context.getSharedPreferences(sharedPrefId, 0));
        }
        for (Map.Entry entry : sharedPrefs.entrySet()) {
            String sharedPrefId = (String)entry.getKey();
            SharedPreferences prefs = (SharedPreferences)entry.getValue();
            Map prefEntries = prefs.getAll();
            if (prefEntries.isEmpty()) {
                result.put(sharedPrefId, (Object)"empty");
                continue;
            }
            Iterator iterator = prefEntries.keySet().iterator();
            while (iterator.hasNext()) {
                if (!this.filteredKey(config, (String)iterator.next())) continue;
                iterator.remove();
            }
            result.put(sharedPrefId, (Object)new JSONObject(prefEntries));
        }
        return result;
    }

    private boolean filteredKey(@NonNull CoreConfiguration config, @NonNull String key) {
        for (String regex : config.excludeMatchingSharedPreferencesKeys()) {
            if (!key.matches(regex)) continue;
            return true;
        }
        return false;
    }
}

