/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DisplayManagerCollector
extends BaseReportFieldCollector {
    public DisplayManagerCollector() {
        super(ReportField.DISPLAY, new ReportField[0]);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) {
        JSONObject result = new JSONObject();
        for (Display display : this.getDisplays(context)) {
            try {
                result.put(String.valueOf(display.getDisplayId()), (Object)this.collectDisplayData(display));
            }
            catch (JSONException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Failed to collect data for display " + display.getDisplayId(), e);
            }
        }
        target.put(ReportField.DISPLAY, result);
    }

    @NonNull
    private Display[] getDisplays(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return ((DisplayManager)context.getSystemService("display")).getDisplays();
        }
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        return new Display[]{display};
    }

    @NonNull
    private JSONObject collectDisplayData(@NonNull Display display) throws JSONException {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        JSONObject result = new JSONObject();
        this.collectCurrentSizeRange(display, result);
        this.collectFlags(display, result);
        this.collectMetrics(display, result);
        this.collectRealMetrics(display, result);
        this.collectName(display, result);
        this.collectRealSize(display, result);
        this.collectRectSize(display, result);
        this.collectSize(display, result);
        this.collectRotation(display, result);
        this.collectIsValid(display, result);
        result.put("orientation", display.getRotation()).put("refreshRate", (double)display.getRefreshRate());
        result.put("height", display.getHeight()).put("width", display.getWidth()).put("pixelFormat", display.getPixelFormat());
        return result;
    }

    private void collectIsValid(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            container.put("isValid", display.isValid());
        }
    }

    private void collectRotation(@NonNull Display display, JSONObject container) throws JSONException {
        container.put("rotation", (Object)this.rotationToString(display.getRotation()));
    }

    @NonNull
    private String rotationToString(int rotation) {
        switch (rotation) {
            case 0: {
                return "ROTATION_0";
            }
            case 1: {
                return "ROTATION_90";
            }
            case 2: {
                return "ROTATION_180";
            }
            case 3: {
                return "ROTATION_270";
            }
        }
        return String.valueOf(rotation);
    }

    private void collectRectSize(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        Rect size = new Rect();
        display.getRectSize(size);
        container.put("rectSize", (Object)new JSONArray(Arrays.asList(size.top, size.left, size.width(), size.height())));
    }

    private void collectSize(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        Point size = new Point();
        display.getSize(size);
        container.put("size", (Object)new JSONArray(Arrays.asList(size.x, size.y)));
    }

    private void collectRealSize(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            Point size = new Point();
            display.getRealSize(size);
            container.put("realSize", (Object)new JSONArray(Arrays.asList(size.x, size.y)));
        }
    }

    private void collectCurrentSizeRange(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 16) {
            Point smallest = new Point();
            Point largest = new Point();
            display.getCurrentSizeRange(smallest, largest);
            JSONObject result = new JSONObject();
            result.put("smallest", (Object)new JSONArray(Arrays.asList(smallest.x, smallest.y)));
            result.put("largest", (Object)new JSONArray(Arrays.asList(largest.x, largest.y)));
            container.put("currentSizeRange", (Object)result);
        }
    }

    private void collectFlags(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            SparseArray flagNames = new SparseArray();
            int flags = display.getFlags();
            for (Field field : display.getClass().getFields()) {
                if (!field.getName().startsWith("FLAG_")) continue;
                try {
                    flagNames.put(field.getInt(null), (Object)field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            container.put("flags", (Object)this.activeFlags((SparseArray<String>)flagNames, flags));
        }
    }

    private void collectName(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            container.put("name", (Object)display.getName());
        }
    }

    private void collectMetrics(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        JSONObject result = new JSONObject();
        this.collectMetrics(metrics, result);
        container.put("metrics", (Object)result);
    }

    private void collectRealMetrics(@NonNull Display display, @NonNull JSONObject container) throws JSONException {
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            display.getRealMetrics(metrics);
            JSONObject result = new JSONObject();
            this.collectMetrics(metrics, result);
            container.put("realMetrics", (Object)result);
        }
    }

    private void collectMetrics(@NonNull DisplayMetrics metrics, @NonNull JSONObject container) throws JSONException {
        container.put("density", (double)metrics.density).put("densityDpi", metrics.densityDpi).put("scaledDensity", (Object)("x" + metrics.scaledDensity)).put("widthPixels", metrics.widthPixels).put("heightPixels", metrics.heightPixels).put("xdpi", (double)metrics.xdpi).put("ydpi", (double)metrics.ydpi);
    }

    @NonNull
    private String activeFlags(SparseArray<String> flagNames, int bitfield) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < flagNames.size(); ++i) {
            int maskValue = flagNames.keyAt(i);
            int value = bitfield & maskValue;
            if (value <= 0) continue;
            if (result.length() > 0) {
                result.append('+');
            }
            result.append((String)flagNames.get(value));
        }
        return result.toString();
    }
}

