/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.acra.ACRA;
import org.acra.util.IOUtils;
import org.acra.util.StreamReader;

public final class Installation {
    private static final String INSTALLATION = "ACRA-INSTALLATION";

    private Installation() {
    }

    @NonNull
    public static synchronized String id(@NonNull Context context) {
        File installation = new File(context.getFilesDir(), INSTALLATION);
        try {
            if (!installation.exists()) {
                IOUtils.writeStringToFile(installation, UUID.randomUUID().toString());
            }
            return new StreamReader(installation).read();
        }
        catch (IOException | RuntimeException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Couldn't retrieve InstallationId for " + context.getPackageName(), e);
            return "Couldn't retrieve InstallationId";
        }
    }
}

