/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import org.acra.ACRA;

public final class IOUtils {
    private IOUtils() {
    }

    public static void safeClose(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteFile(@NonNull File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            ACRA.log.w(ACRA.LOG_TAG, "Could not delete file: " + file);
        }
    }

    public static void writeStringToFile(@NonNull File file, @NonNull String content) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(content);
            writer.flush();
        }
        finally {
            IOUtils.safeClose(writer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String serialize(@NonNull Serializable serializable) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream outputStream = new ObjectOutputStream(out);){
            outputStream.writeObject(serializable);
            String string = Base64.encodeToString((byte[])out.toByteArray(), (int)0);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T extends Serializable> T deserialize(@NonNull Class<T> clazz, @Nullable String s) {
        if (s == null) return null;
        try (ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)s, (int)0)));){
            Object o = inputStream.readObject();
            if (!clazz.isInstance(o)) return null;
            Serializable serializable = (Serializable)clazz.cast(o);
            return (T)serializable;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

