/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.os.Build;
import android.os.Bundle;
import android.os.PersistableBundle;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Proxy;
import java.util.Set;

@Keep
public interface BundleWrapper {
    public int size();

    public boolean isEmpty();

    public void clear();

    public boolean containsKey(String var1);

    @Nullable
    public Object get(String var1);

    public void remove(String var1);

    @RequiresApi(api=21)
    public void putAll(PersistableBundle var1);

    public Set<String> keySet();

    public void putBoolean(@Nullable String var1, boolean var2);

    public void putInt(@Nullable String var1, int var2);

    public void putLong(@Nullable String var1, long var2);

    public void putDouble(@Nullable String var1, double var2);

    public void putString(@Nullable String var1, @Nullable String var2);

    public void putBooleanArray(@Nullable String var1, @Nullable boolean[] var2);

    public void putIntArray(@Nullable String var1, @Nullable int[] var2);

    public void putLongArray(@Nullable String var1, @Nullable long[] var2);

    public void putDoubleArray(@Nullable String var1, @Nullable double[] var2);

    public void putStringArray(@Nullable String var1, @Nullable String[] var2);

    public boolean getBoolean(String var1);

    public boolean getBoolean(String var1, boolean var2);

    public int getInt(String var1);

    public int getInt(String var1, int var2);

    public long getLong(String var1);

    public long getLong(String var1, long var2);

    public double getDouble(String var1);

    public double getDouble(String var1, double var2);

    @Nullable
    public String getString(@Nullable String var1);

    public String getString(@Nullable String var1, String var2);

    @Nullable
    public boolean[] getBooleanArray(@Nullable String var1);

    @Nullable
    public int[] getIntArray(@Nullable String var1);

    @Nullable
    public long[] getLongArray(@Nullable String var1);

    @Nullable
    public double[] getDoubleArray(@Nullable String var1);

    @Nullable
    public String[] getStringArray(@Nullable String var1);

    public static BundleWrapper wrap(@Nullable Bundle bundle) {
        Internal wrapper = BundleWrapper.create();
        if (bundle != null) {
            for (String key : bundle.keySet()) {
                Object o = bundle.get(key);
                if (o instanceof Integer) {
                    wrapper.putInt(key, (Integer)o);
                    continue;
                }
                if (o instanceof int[]) {
                    wrapper.putIntArray(key, (int[])o);
                    continue;
                }
                if (o instanceof Long) {
                    wrapper.putLong(key, (Long)o);
                    continue;
                }
                if (o instanceof long[]) {
                    wrapper.putLongArray(key, (long[])o);
                    continue;
                }
                if (o instanceof Double) {
                    wrapper.putDouble(key, (Double)o);
                    continue;
                }
                if (o instanceof double[]) {
                    wrapper.putDoubleArray(key, (double[])o);
                    continue;
                }
                if (o instanceof String) {
                    wrapper.putString(key, (String)o);
                    continue;
                }
                if (o instanceof String[]) {
                    wrapper.putStringArray(key, (String[])o);
                    continue;
                }
                if (o instanceof Boolean) {
                    wrapper.putBoolean(key, (Boolean)o);
                    continue;
                }
                if (!(o instanceof boolean[])) continue;
                wrapper.putBooleanArray(key, (boolean[])o);
            }
        }
        return wrapper;
    }

    @RequiresApi(api=21)
    public static BundleWrapper wrap(@Nullable PersistableBundle bundle) {
        Internal wrapper = BundleWrapper.create();
        if (bundle != null) {
            wrapper.putAll(bundle);
        }
        return wrapper;
    }

    public static Internal create() {
        PersistableBundle wrap = Build.VERSION.SDK_INT >= 22 ? new PersistableBundle() : new Bundle();
        return (Internal)Proxy.newProxyInstance(BundleWrapper.class.getClassLoader(), new Class[]{Internal.class}, (proxy, method, args) -> {
            if (method.getName().equals("asPersistableBundle")) {
                if (Build.VERSION.SDK_INT >= 22) {
                    return wrap;
                }
                return null;
            }
            if (method.getName().equals("asBundle")) {
                if (Build.VERSION.SDK_INT < 22) {
                    return wrap;
                }
                return null;
            }
            return wrap.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(wrap, args);
        });
    }

    @Keep
    public static interface Internal
    extends BundleWrapper {
        @RequiresApi(value=22)
        public PersistableBundle asPersistableBundle();

        public Bundle asBundle();
    }
}

