/*
 * Decompiled with CFR 0.152.
 */
package org.acra.reporter;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ErrorReporter;
import org.acra.builder.LastActivityManager;
import org.acra.builder.ReportBuilder;
import org.acra.builder.ReportExecutor;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportDataFactory;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.scheduler.SchedulerStarter;
import org.acra.scheduler.SenderScheduler;
import org.acra.startup.StartupProcessorExecutor;
import org.acra.util.ApplicationStartupProcessor;
import org.acra.util.InstanceCreator;
import org.acra.util.ProcessFinisher;

public class ErrorReporterImpl
implements Thread.UncaughtExceptionHandler,
SharedPreferences.OnSharedPreferenceChangeListener,
ErrorReporter {
    private final boolean supportedAndroidVersion;
    private final Application context;
    private final ReportExecutor reportExecutor;
    private final Map<String, String> customData = new HashMap<String, String>();
    private final SchedulerStarter schedulerStarter;
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;

    public ErrorReporterImpl(@NonNull Application context, @NonNull CoreConfiguration config, boolean enabled, boolean supportedAndroidVersion, boolean checkReportsOnApplicationStart) {
        this.context = context;
        this.supportedAndroidVersion = supportedAndroidVersion;
        CrashReportDataFactory crashReportDataFactory = new CrashReportDataFactory((Context)context, config);
        crashReportDataFactory.collectStartUp();
        this.defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        LastActivityManager lastActivityManager = new LastActivityManager(this.context);
        InstanceCreator instanceCreator = new InstanceCreator();
        ProcessFinisher processFinisher = new ProcessFinisher((Context)context, config, lastActivityManager);
        this.schedulerStarter = new SchedulerStarter((Context)context, config);
        this.reportExecutor = new ReportExecutor((Context)context, config, crashReportDataFactory, this.defaultExceptionHandler, processFinisher, this.schedulerStarter, lastActivityManager);
        this.reportExecutor.setEnabled(enabled);
        if (checkReportsOnApplicationStart) {
            new StartupProcessorExecutor((Context)context, config, this.schedulerStarter).processReports(enabled);
            new ApplicationStartupProcessor((Context)context, config).checkReports();
        }
    }

    @Override
    public String putCustomData(@NonNull String key, @Nullable String value) {
        return this.customData.put(key, value);
    }

    @Override
    @Nullable
    public String removeCustomData(@NonNull String key) {
        return this.customData.remove(key);
    }

    @Override
    public void clearCustomData() {
        this.customData.clear();
    }

    @Override
    @Nullable
    public String getCustomData(@NonNull String key) {
        return this.customData.get(key);
    }

    @Override
    public void uncaughtException(@Nullable Thread t, @NonNull Throwable e) {
        if (!this.reportExecutor.isEnabled()) {
            this.reportExecutor.handReportToDefaultExceptionHandler(t, e);
            return;
        }
        try {
            ACRA.log.e(ACRA.LOG_TAG, "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.context.getPackageName(), e);
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Building report");
            }
            new ReportBuilder().uncaughtExceptionThread(t).exception(e).customData(this.customData).endApplication().build(this.reportExecutor);
        }
        catch (Exception fatality) {
            ACRA.log.e(ACRA.LOG_TAG, "ACRA failed to capture the error - handing off to native error reporter", fatality);
            this.reportExecutor.handReportToDefaultExceptionHandler(t, e);
        }
    }

    @Override
    public void handleSilentException(@Nullable Throwable e) {
        new ReportBuilder().exception(e).customData(this.customData).sendSilently().build(this.reportExecutor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.supportedAndroidVersion) {
            ACRA.log.i(ACRA.LOG_TAG, "ACRA is " + (enabled ? "enabled" : "disabled") + " for " + this.context.getPackageName());
            this.reportExecutor.setEnabled(enabled);
        } else {
            ACRA.log.w(ACRA.LOG_TAG, "ACRA requires ICS or greater. ACRA is disabled and will NOT catch crashes or send messages.");
        }
    }

    @Override
    public void handleException(@Nullable Throwable e, boolean endApplication) {
        ReportBuilder builder = new ReportBuilder();
        builder.exception(e).customData(this.customData);
        if (endApplication) {
            builder.endApplication();
        }
        builder.build(this.reportExecutor);
    }

    @Override
    public void handleException(@Nullable Throwable e) {
        this.handleException(e, false);
    }

    @Override
    public SenderScheduler getReportScheduler() {
        return this.schedulerStarter.getSenderScheduler();
    }

    public void onSharedPreferenceChanged(@NonNull SharedPreferences sharedPreferences, @Nullable String key) {
        if ("acra.disable".equals(key) || "acra.enable".equals(key)) {
            this.setEnabled(SharedPreferencesFactory.shouldEnableACRA(sharedPreferences));
        }
    }

    public void unregister() {
        Thread.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
    }
}

