/*
 * Decompiled with CFR 0.152.
 */
package org.acra.legacy;

import android.content.Context;
import androidx.annotation.NonNull;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.data.CrashReportData;
import org.acra.file.CrashReportPersister;
import org.acra.file.ReportLocator;
import org.acra.util.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

class ReportConverter {
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;
    private final Context context;

    ReportConverter(@NonNull Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convert() {
        ACRA.log.i(ACRA.LOG_TAG, "Converting unsent ACRA reports to json");
        ReportLocator locator = new ReportLocator(this.context);
        CrashReportPersister persister = new CrashReportPersister();
        ArrayList<File> reportFiles = new ArrayList<File>();
        reportFiles.addAll(Arrays.asList(locator.getUnapprovedReports()));
        reportFiles.addAll(Arrays.asList(locator.getApprovedReports()));
        int converted = 0;
        for (File report : reportFiles) {
            BufferedInputStream in;
            block9: {
                in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(report), 8192);
                    CrashReportData data = this.legacyLoad(new InputStreamReader((InputStream)in, "ISO8859-1"));
                    if (data.containsKey(ReportField.REPORT_ID) && data.containsKey(ReportField.USER_CRASH_DATE)) {
                        persister.store(data, report);
                        ++converted;
                        break block9;
                    }
                    IOUtils.deleteFile(report);
                }
                catch (Exception e) {
                    try {
                        try {
                            persister.load(report);
                            if (ACRA.DEV_LOGGING) {
                                ACRA.log.d(ACRA.LOG_TAG, "Tried to convert already converted report file " + report.getPath() + ". Ignoring");
                            }
                        }
                        catch (Exception t) {
                            ACRA.log.w(ACRA.LOG_TAG, "Unable to read report file " + report.getPath() + ". Deleting", e);
                            IOUtils.deleteFile(report);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.safeClose(in);
                        throw throwable;
                    }
                    IOUtils.safeClose(in);
                    continue;
                }
            }
            IOUtils.safeClose(in);
        }
        ACRA.log.i(ACRA.LOG_TAG, "Converted " + converted + " unsent reports");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private synchronized CrashReportData legacyLoad(@NonNull Reader reader) throws IOException {
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        CrashReportData crashData = new CrashReportData();
        BufferedReader br = new BufferedReader(reader, 8192);
        try {
            int intVal;
            block20: while ((intVal = br.read()) != -1) {
                int nextChar = intVal;
                if (offset == buf.length) {
                    char[] newBuf = new char[buf.length * 2];
                    System.arraycopy(buf, 0, newBuf, 0, offset);
                    buf = newBuf;
                }
                if (mode == 2) {
                    int digit = Character.digit((char)nextChar, 16);
                    if (digit >= 0) {
                        unicode = (unicode << 4) + digit;
                        if (++count < 4) {
                            continue;
                        }
                    } else if (count <= 4) {
                        throw new IllegalArgumentException("luni.09");
                    }
                    mode = 0;
                    buf[offset++] = (char)unicode;
                    if (nextChar != 10 && nextChar != 133) continue;
                }
                if (mode == 1) {
                    mode = 0;
                    switch (nextChar) {
                        case 13: {
                            mode = 3;
                            continue block20;
                        }
                        case 10: 
                        case 133: {
                            mode = 5;
                            continue block20;
                        }
                        case 98: {
                            nextChar = 8;
                            break;
                        }
                        case 102: {
                            nextChar = 12;
                            break;
                        }
                        case 110: {
                            nextChar = 10;
                            break;
                        }
                        case 114: {
                            nextChar = 13;
                            break;
                        }
                        case 116: {
                            nextChar = 9;
                            break;
                        }
                        case 117: {
                            mode = 2;
                            count = 0;
                            unicode = 0;
                            continue block20;
                        }
                    }
                } else {
                    switch (nextChar) {
                        case 33: 
                        case 35: {
                            if (!firstChar) break;
                            while ((intVal = br.read()) != -1 && (nextChar = (int)((char)intVal)) != 13 && nextChar != 10 && nextChar != 133) {
                            }
                            continue block20;
                        }
                        case 10: {
                            if (mode == 3) {
                                mode = 5;
                                continue block20;
                            }
                        }
                        case 13: 
                        case 133: {
                            mode = 0;
                            firstChar = true;
                            if (offset > 0 || offset == 0 && keyLength == 0) {
                                if (keyLength == -1) {
                                    keyLength = offset;
                                }
                                String temp = new String(buf, 0, offset);
                                this.putKeyValue(crashData, temp.substring(0, keyLength), temp.substring(keyLength));
                            }
                            keyLength = -1;
                            offset = 0;
                            continue block20;
                        }
                        case 92: {
                            if (mode == 4) {
                                keyLength = offset;
                            }
                            mode = 1;
                            continue block20;
                        }
                        case 58: 
                        case 61: {
                            if (keyLength != -1) break;
                            mode = 0;
                            keyLength = offset;
                            continue block20;
                        }
                    }
                    if (Character.isWhitespace((char)nextChar)) {
                        if (mode == 3) {
                            mode = 5;
                        }
                        if (offset == 0 || offset == keyLength || mode == 5) continue;
                        if (keyLength == -1) {
                            mode = 4;
                            continue;
                        }
                    }
                    if (mode == 5 || mode == 3) {
                        mode = 0;
                    }
                }
                firstChar = false;
                if (mode == 4) {
                    keyLength = offset;
                    mode = 0;
                }
                buf[offset++] = nextChar;
            }
            if (mode == 2 && count <= 4) {
                throw new IllegalArgumentException("luni.08");
            }
            if (keyLength == -1 && offset > 0) {
                keyLength = offset;
            }
            if (keyLength >= 0) {
                String temp = new String(buf, 0, offset);
                String value = temp.substring(keyLength);
                if (mode == 1) {
                    value = value + "\u0000";
                }
                this.putKeyValue(crashData, temp.substring(0, keyLength), value);
            }
            IOUtils.safeClose(reader);
            CrashReportData crashReportData = crashData;
            return crashReportData;
        }
        finally {
            IOUtils.safeClose(br);
        }
    }

    private void putKeyValue(@NonNull CrashReportData crashData, @NonNull String key, @NonNull String value) {
        try {
            crashData.put(key, new JSONObject(value));
        }
        catch (JSONException e1) {
            try {
                crashData.put(key, (double)Double.valueOf(value));
            }
            catch (NumberFormatException e2) {
                switch (value) {
                    case "true": {
                        crashData.put(key, true);
                        break;
                    }
                    case "false": {
                        crashData.put(key, false);
                        break;
                    }
                    default: {
                        crashData.put(key, value);
                    }
                }
            }
        }
    }
}

