/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import java.io.Serializable;
import org.acra.config.CoreConfiguration;
import org.acra.scheduler.SenderScheduler;
import org.acra.sender.JobSenderService;
import org.acra.sender.LegacySenderService;
import org.acra.sender.SendingConductor;
import org.acra.util.IOUtils;

public class DefaultSenderScheduler
implements SenderScheduler {
    private final Context context;
    private final CoreConfiguration config;

    public DefaultSenderScheduler(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.context = context;
        this.config = config;
    }

    @Override
    public void scheduleReportSending(boolean onlySendSilentReports) {
        SendingConductor conductor = new SendingConductor(this.context, this.config);
        if (!conductor.getSenderInstances(false).isEmpty()) {
            Intent intent = new Intent();
            intent.putExtra("onlySendSilentReports", onlySendSilentReports);
            intent.putExtra("acraConfig", (Serializable)this.config);
            if (Build.VERSION.SDK_INT >= 22) {
                JobScheduler scheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
                PersistableBundle extras = new PersistableBundle();
                extras.putString("acraConfig", IOUtils.serialize(this.config));
                extras.putBoolean("onlySendSilentReports", onlySendSilentReports);
                assert (scheduler != null);
                JobInfo.Builder builder = new JobInfo.Builder(0, new ComponentName(this.context, JobSenderService.class)).setOverrideDeadline(0L).setExtras(extras);
                this.configureJob(builder);
                scheduler.schedule(builder.build());
            } else {
                intent.setComponent(new ComponentName(this.context, LegacySenderService.class));
                this.context.startService(intent);
            }
        }
        if (!conductor.getSenderInstances(true).isEmpty()) {
            conductor.sendReports(onlySendSilentReports, true);
        }
    }

    protected void configureJob(JobInfo.Builder job) {
    }
}

