/*
 * Decompiled with CFR 0.152.
 */
package org.acra.prefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import org.acra.config.CoreConfiguration;

public class SharedPreferencesFactory {
    private final Context context;
    private final CoreConfiguration config;

    public SharedPreferencesFactory(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.context = context;
        this.config = config;
    }

    public static boolean shouldEnableACRA(@NonNull SharedPreferences prefs) {
        boolean enableAcra = true;
        try {
            boolean disableAcra = prefs.getBoolean("acra.disable", false);
            enableAcra = prefs.getBoolean("acra.enable", !disableAcra);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return enableAcra;
    }

    @NonNull
    public SharedPreferences create() {
        if (this.context == null) {
            throw new IllegalStateException("Cannot call ACRA.getACRASharedPreferences() before ACRA.init().");
        }
        if (!"".equals(this.config.sharedPreferencesName())) {
            return this.context.getSharedPreferences(this.config.sharedPreferencesName(), 0);
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)this.context);
    }
}

