/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.acra.ACRA;
import org.acra.collections.ImmutableList;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.plugins.PluginLoader;
import org.acra.sender.NullSender;
import org.acra.sender.ReportDistributor;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderFactory;
import org.acra.util.InstanceCreator;
import org.acra.util.ToastSender;

public class SendingConductor {
    private final Context context;
    private final CoreConfiguration config;
    private final ReportLocator locator;

    public SendingConductor(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.context = context;
        this.config = config;
        this.locator = new ReportLocator(context);
    }

    public void sendReports(boolean onlySendSilentReports) {
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "About to start sending reports from SenderService");
        }
        try {
            String toast;
            List<ReportSender> senderInstances = this.getSenderInstances();
            File[] reports = this.locator.getApprovedReports();
            ReportDistributor reportDistributor = new ReportDistributor(this.context, this.config, senderInstances);
            int reportsSentCount = 0;
            CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
            boolean anyNonSilent = false;
            for (File report : reports) {
                boolean isNonSilent;
                boolean bl = isNonSilent = !fileNameParser.isSilent(report.getName());
                if (onlySendSilentReports && isNonSilent) continue;
                anyNonSilent |= isNonSilent;
                if (reportsSentCount >= 5) break;
                if (!reportDistributor.distribute(report)) continue;
                ++reportsSentCount;
            }
            if (anyNonSilent && (toast = reportsSentCount > 0 ? this.config.reportSendSuccessToast() : this.config.reportSendFailureToast()) != null) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "About to show " + (reportsSentCount > 0 ? "success" : "failure") + " toast");
                }
                new Handler(Looper.getMainLooper()).post(() -> ToastSender.sendToast(this.context, toast, 1));
            }
        }
        catch (Exception e) {
            ACRA.log.e(ACRA.LOG_TAG, "", e);
        }
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Finished sending reports from SenderService");
        }
    }

    @NonNull
    private List<ReportSender> getSenderInstances() {
        List<? extends ReportSenderFactory> factories;
        ImmutableList<Class<? extends ReportSenderFactory>> factoryClasses = this.config.reportSenderFactoryClasses();
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "config#reportSenderFactoryClasses : " + factoryClasses);
        }
        if (factoryClasses.isEmpty()) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Using PluginLoader to find ReportSender factories");
            }
            PluginLoader loader = this.config.pluginLoader();
            factories = loader.loadEnabled(this.config, ReportSenderFactory.class);
        } else {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Creating reportSenderFactories for reportSenderFactory config");
            }
            factories = new InstanceCreator().create(factoryClasses);
        }
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "reportSenderFactories : " + factories);
        }
        ArrayList<ReportSender> reportSenders = new ArrayList<ReportSender>();
        for (ReportSenderFactory reportSenderFactory : factories) {
            ReportSender sender = reportSenderFactory.create(this.context, this.config);
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Adding reportSender : " + sender);
            }
            reportSenders.add(sender);
        }
        if (reportSenders.isEmpty()) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "No ReportSenders configured - adding NullSender");
            }
            reportSenders.add(new NullSender());
        }
        return reportSenders;
    }
}

