/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.acra.ACRA;

public final class IOUtils {
    private IOUtils() {
    }

    public static void safeClose(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteFile(@NonNull File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            ACRA.log.w(ACRA.LOG_TAG, "Could not delete file: " + file);
        }
    }

    public static void writeStringToFile(@NonNull File file, @NonNull String content) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(content);
            writer.flush();
        }
        finally {
            IOUtils.safeClose(writer);
        }
    }
}

