/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaCodecListCollector
extends BaseReportFieldCollector {
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    private static final String[] MPEG4_TYPES = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
    private static final String[] AVC_TYPES = new String[]{"avc", "h264", "AVC", "H264"};
    private static final String[] H263_TYPES = new String[]{"h263", "H263"};
    private static final String[] AAC_TYPES = new String[]{"aac", "AAC"};
    private final SparseArray<String> mColorFormatValues = new SparseArray();
    private final SparseArray<String> mAVCLevelValues = new SparseArray();
    private final SparseArray<String> mAVCProfileValues = new SparseArray();
    private final SparseArray<String> mH263LevelValues = new SparseArray();
    private final SparseArray<String> mH263ProfileValues = new SparseArray();
    private final SparseArray<String> mMPEG4LevelValues = new SparseArray();
    private final SparseArray<String> mMPEG4ProfileValues = new SparseArray();
    private final SparseArray<String> mAACProfileValues = new SparseArray();

    public MediaCodecListCollector() {
        super(ReportField.MEDIA_CODEC_LIST, new ReportField[0]);
    }

    @Override
    @NonNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws JSONException {
        target.put(ReportField.MEDIA_CODEC_LIST, this.collectMediaCodecList());
    }

    @Override
    boolean shouldCollect(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportField collect, @NonNull ReportBuilder reportBuilder) {
        return super.shouldCollect(context, config, collect, reportBuilder) && Build.VERSION.SDK_INT >= 16;
    }

    private void prepare() {
        try {
            Class<?> codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            for (Field f : codecCapabilitiesClass.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getName().startsWith(COLOR_FORMAT_PREFIX)) continue;
                this.mColorFormatValues.put(f.getInt(null), (Object)f.getName());
            }
            Class<?> codecProfileLevelClass = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
            for (Field f : codecProfileLevelClass.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                if (f.getName().startsWith("AVCLevel")) {
                    this.mAVCLevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("AVCProfile")) {
                    this.mAVCProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("H263Level")) {
                    this.mH263LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("H263Profile")) {
                    this.mH263ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("MPEG4Level")) {
                    this.mMPEG4LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("MPEG4Profile")) {
                    this.mMPEG4ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (!f.getName().startsWith("AAC")) continue;
                this.mAACProfileValues.put(f.getInt(null), (Object)f.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @TargetApi(value=16)
    @NonNull
    private JSONObject collectMediaCodecList() throws JSONException {
        MediaCodecInfo[] infos;
        this.prepare();
        if (Build.VERSION.SDK_INT < 21) {
            int codecCount = MediaCodecList.getCodecCount();
            infos = new MediaCodecInfo[codecCount];
            for (int codecIdx = 0; codecIdx < codecCount; ++codecIdx) {
                infos[codecIdx] = MediaCodecList.getCodecInfoAt((int)codecIdx);
            }
        } else {
            infos = new MediaCodecList(1).getCodecInfos();
        }
        JSONObject result = new JSONObject();
        for (int i = 0; i < infos.length; ++i) {
            MediaCodecInfo codecInfo = infos[i];
            JSONObject codec = new JSONObject();
            String[] supportedTypes = codecInfo.getSupportedTypes();
            codec.put("name", (Object)codecInfo.getName()).put("isEncoder", codecInfo.isEncoder());
            JSONObject supportedTypesJson = new JSONObject();
            for (String type : supportedTypes) {
                supportedTypesJson.put(type, (Object)this.collectCapabilitiesForType(codecInfo, type));
            }
            codec.put("supportedTypes", (Object)supportedTypesJson);
            result.put(String.valueOf(i), (Object)codec);
        }
        return result;
    }

    @NonNull
    @TargetApi(value=16)
    private JSONObject collectCapabilitiesForType(@NonNull MediaCodecInfo codecInfo, @NonNull String type) throws JSONException {
        JSONObject result = new JSONObject();
        MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
        int[] colorFormats = codecCapabilities.colorFormats;
        if (colorFormats.length > 0) {
            JSONArray colorFormatsJson = new JSONArray();
            for (int colorFormat : colorFormats) {
                colorFormatsJson.put(this.mColorFormatValues.get(colorFormat));
            }
            result.put("colorFormats", (Object)colorFormatsJson);
        }
        CodecType codecType = this.identifyCodecType(codecInfo);
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevels = codecCapabilities.profileLevels;
        if (codecProfileLevels.length > 0) {
            JSONArray profileLevels = new JSONArray();
            block7: for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecProfileLevels) {
                int profileValue = codecProfileLevel.profile;
                int levelValue = codecProfileLevel.level;
                if (codecType == null) {
                    profileLevels.put(profileValue + 45 + levelValue);
                    break;
                }
                switch (codecType) {
                    case AVC: {
                        profileLevels.put((Object)(profileValue + (String)this.mAVCProfileValues.get(profileValue) + '-' + (String)this.mAVCLevelValues.get(levelValue)));
                        continue block7;
                    }
                    case H263: {
                        profileLevels.put((Object)((String)this.mH263ProfileValues.get(profileValue) + '-' + (String)this.mH263LevelValues.get(levelValue)));
                        continue block7;
                    }
                    case MPEG4: {
                        profileLevels.put((Object)((String)this.mMPEG4ProfileValues.get(profileValue) + '-' + (String)this.mMPEG4LevelValues.get(levelValue)));
                        continue block7;
                    }
                    case AAC: {
                        profileLevels.put(this.mAACProfileValues.get(profileValue));
                        continue block7;
                    }
                }
            }
            result.put("profileLevels", (Object)profileLevels);
        }
        return result;
    }

    @Nullable
    @TargetApi(value=16)
    private CodecType identifyCodecType(@NonNull MediaCodecInfo codecInfo) {
        String name = codecInfo.getName();
        for (String token : AVC_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.AVC;
        }
        for (String token : H263_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.H263;
        }
        for (String token : MPEG4_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.MPEG4;
        }
        for (String token : AAC_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.AAC;
        }
        return null;
    }

    private static enum CodecType {
        AVC,
        H263,
        MPEG4,
        AAC;

    }
}

