/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.app.ActivityManager;
import android.app.NotificationManager;
import android.content.Context;
import android.os.DropBoxManager;
import android.telephony.TelephonyManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/acra/util/SystemServices;", "", "<init>", "()V", "getTelephonyManager", "Landroid/telephony/TelephonyManager;", "context", "Landroid/content/Context;", "getDropBoxManager", "Landroid/os/DropBoxManager;", "getNotificationManager", "Landroid/app/NotificationManager;", "getActivityManager", "Landroid/app/ActivityManager;", "getService", "id", "", "ServiceNotReachedException", "acra-core_release"})
public final class SystemServices {
    @NotNull
    public static final SystemServices INSTANCE = new SystemServices();

    private SystemServices() {
    }

    @JvmStatic
    @NotNull
    public static final TelephonyManager getTelephonyManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = INSTANCE.getService(context, "phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        return (TelephonyManager)object;
    }

    @JvmStatic
    @NotNull
    public static final DropBoxManager getDropBoxManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = INSTANCE.getService(context, "dropbox");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.DropBoxManager");
        return (DropBoxManager)object;
    }

    @JvmStatic
    @NotNull
    public static final NotificationManager getNotificationManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = INSTANCE.getService(context, "notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        return (NotificationManager)object;
    }

    @JvmStatic
    @NotNull
    public static final ActivityManager getActivityManager(@NotNull Context context) throws ServiceNotReachedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = INSTANCE.getService(context, "activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        return (ActivityManager)object;
    }

    private final Object getService(Context context, String id) throws ServiceNotReachedException {
        Object object = context.getSystemService(id);
        if (object == null) {
            throw new ServiceNotReachedException("Unable to load SystemService " + id);
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/acra/util/SystemServices$ServiceNotReachedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "acra-core_release"})
    public static final class ServiceNotReachedException
    extends Exception {
        public ServiceNotReachedException(@Nullable String message) {
            super(message);
        }
    }
}

