/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u001c\u0010\u001a\u001a\u00020\u00002\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bJ\u0006\u0010\u001c\u001a\u00020\tJ\b\u0010\u001d\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\u001c\u0010\u001f\u001a\u00020\u0005*\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R(\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lorg/acra/util/StreamReader;", "", "inputStream", "Ljava/io/InputStream;", "limit", "", "timeout", "filter", "Lkotlin/Function1;", "", "", "<init>", "(Ljava/io/InputStream;IILkotlin/jvm/functions/Function1;)V", "filename", "(Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getLimit", "()I", "setLimit", "(I)V", "getTimeout", "setTimeout", "getFilter", "()Lkotlin/jvm/functions/Function1;", "setFilter", "(Lkotlin/jvm/functions/Function1;)V", "read", "readFully", "readWithTimeout", "readUntil", "buffer", "", "until", "", "Companion", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamReader.kt\norg/acra/util/StreamReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n1#3:101\n*S KotlinDebug\n*F\n+ 1 StreamReader.kt\norg/acra/util/StreamReader\n*L\n55#1:98\n55#1:99,2\n*E\n"})
public final class StreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream inputStream;
    private int limit;
    private int timeout;
    @Nullable
    private Function1<? super String, Boolean> filter;
    private static final int NO_LIMIT = -1;
    private static final int INDEFINITE = -1;
    @NotNull
    private static final Regex newline = new Regex("\\r?\\n");

    public StreamReader(@NotNull InputStream inputStream, int limit, int timeout, @Nullable Function1<? super String, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
        this.limit = limit;
        this.timeout = timeout;
        this.filter = filter;
    }

    public /* synthetic */ StreamReader(InputStream inputStream, int n, int n2, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            function1 = null;
        }
        this(inputStream, n, n2, (Function1<? super String, Boolean>)function1);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int n) {
        this.timeout = n;
    }

    @Nullable
    public final Function1<String, Boolean> getFilter() {
        return this.filter;
    }

    public final void setFilter(@Nullable Function1<? super String, Boolean> function1) {
        this.filter = function1;
    }

    public StreamReader(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this(new File(filename));
    }

    public StreamReader(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(new FileInputStream(file), 0, 0, null, 14, null);
    }

    @NotNull
    public final StreamReader setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @NotNull
    public final StreamReader setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @NotNull
    public final StreamReader setFilter(@Nullable Function1<? super String, Boolean> filter) {
        this.filter = filter;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String read() throws IOException {
        Object object;
        block7: {
            String text;
            block6: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                text = this.timeout == -1 ? this.readFully() : this.readWithTimeout();
                object = this.filter;
                if (object == null) break block6;
                Function1<? super String, Boolean> it = object;
                boolean bl = false;
                Object object2 = text;
                Regex regex = newline;
                int n = 0;
                object2 = regex.split((CharSequence)object2, n);
                boolean $i$f$filter = false;
                void var7_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)it.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List $this$read_u24lambda_u241_u24lambda_u240 = (List)destination$iv$iv;
                boolean bl2 = false;
                String string = CollectionsKt.joinToString$default((Iterable)(this.limit == -1 ? $this$read_u24lambda_u241_u24lambda_u240 : CollectionsKt.takeLast((List)$this$read_u24lambda_u241_u24lambda_u240, (int)this.limit)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                object = string;
                if (string != null) break block7;
            }
            if (this.limit == -1) {
                object = text;
            } else {
                CharSequence charSequence = text;
                Regex regex = newline;
                int n = 0;
                object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)regex.split(charSequence, n), (int)this.limit), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readFully() throws IOException {
        Closeable closeable = this.inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader p0 = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)p0);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readWithTimeout() throws IOException {
        String string;
        long until = System.currentTimeMillis() + (long)this.timeout;
        Closeable closeable = this.inputStream;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int count = 0;
            while (true) {
                int n;
                int it = n = this.readUntil(input, buffer, until);
                boolean bl2 = false;
                count = it;
                if (n == -1) break;
                output.write(buffer, 0, count);
            }
            String string2 = output.toString();
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    private final int readUntil(InputStream $this$readUntil, byte[] buffer, long until) throws IOException {
        int bufferOffset;
        int readResult;
        for (bufferOffset = 0; System.currentTimeMillis() < until && bufferOffset < buffer.length && (readResult = $this$readUntil.read(buffer, bufferOffset, Math.min(this.inputStream.available(), buffer.length - bufferOffset))) != -1; bufferOffset += readResult) {
        }
        return bufferOffset;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/acra/util/StreamReader$Companion;", "", "<init>", "()V", "NO_LIMIT", "", "INDEFINITE", "newline", "Lkotlin/text/Regex;", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

