/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Process;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.builder.LastActivityManager;
import org.acra.config.CoreConfiguration;
import org.acra.log.ACRALog;
import org.acra.util.SystemServices;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/acra/util/ProcessFinisher;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "lastActivityManager", "Lorg/acra/builder/LastActivityManager;", "<init>", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;Lorg/acra/builder/LastActivityManager;)V", "endApplication", "", "finishLastActivity", "uncaughtExceptionThread", "Ljava/lang/Thread;", "stopServices", "killProcessAndExit", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nProcessFinisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessFinisher.kt\norg/acra/util/ProcessFinisher\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,94:1\n7#2,2:95\n7#2,2:97\n27#2,2:99\n7#2,2:101\n*S KotlinDebug\n*F\n+ 1 ProcessFinisher.kt\norg/acra/util/ProcessFinisher\n*L\n45#1:95,2\n80#1:97,2\n85#1:99,2\n50#1:101,2\n*E\n"})
public final class ProcessFinisher {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final LastActivityManager lastActivityManager;

    public ProcessFinisher(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull LastActivityManager lastActivityManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)lastActivityManager, (String)"lastActivityManager");
        this.context = context;
        this.config = config;
        this.lastActivityManager = lastActivityManager;
    }

    public final void endApplication() {
        this.stopServices();
        this.killProcessAndExit();
    }

    public final void finishLastActivity(@Nullable Thread uncaughtExceptionThread) {
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Finishing activities prior to killing the Process";
            aCRALog.d(string, string2);
        }
        boolean wait = false;
        for (Activity activity : this.lastActivityManager.getLastActivities()) {
            Runnable finisher = () -> ProcessFinisher.finishLastActivity$lambda$2(activity);
            if (uncaughtExceptionThread == activity.getMainLooper().getThread()) {
                finisher.run();
                continue;
            }
            wait = true;
            activity.runOnUiThread(finisher);
        }
        if (wait) {
            this.lastActivityManager.waitForAllActivitiesDestroy(100);
        }
        this.lastActivityManager.clearLastActivities();
    }

    private final void stopServices() {
        if (this.config.getStopServicesOnCrash()) {
            try {
                ActivityManager activityManager = SystemServices.getActivityManager(this.context);
                List runningServices = activityManager.getRunningServices(Integer.MAX_VALUE);
                int pid = Process.myPid();
                for (ActivityManager.RunningServiceInfo serviceInfo : runningServices) {
                    if (serviceInfo.pid != pid) continue;
                    String string = serviceInfo.service.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"org.acra", (boolean)false, (int)2, null)) continue;
                    try {
                        Intent intent = new Intent();
                        intent.setComponent(serviceInfo.service);
                        this.context.stopService(intent);
                    }
                    catch (SecurityException e) {
                        boolean $i$f$debug = false;
                        if (!ACRA.DEV_LOGGING) continue;
                        String string2 = ACRA.LOG_TAG;
                        ACRALog aCRALog = ACRA.log;
                        boolean bl = false;
                        String string3 = "Unable to stop Service " + serviceInfo.service.getClassName() + ". Permission denied";
                        aCRALog.d(string2, string3);
                    }
                }
            }
            catch (SystemServices.ServiceNotReachedException e) {
                Throwable throwable$iv = e;
                boolean $i$f$error = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string4 = "Unable to stop services";
                aCRALog.e(string, string4, throwable$iv);
            }
        }
    }

    private final void killProcessAndExit() {
        Process.killProcess((int)Process.myPid());
        System.exit(10);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void finishLastActivity$lambda$2(Activity $activity) {
        $activity.finish();
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Finished " + $activity.getClass();
            aCRALog.d(string, string2);
        }
    }
}

