/*
 * Decompiled with CFR 0.152.
 */
package org.acra.startup;

import android.content.Context;
import android.os.Handler;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.interaction.ReportInteractionExecutor;
import org.acra.scheduler.SchedulerStarter;
import org.acra.startup.Report;
import org.acra.startup.StartupProcessor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/acra/startup/StartupProcessorExecutor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "schedulerStarter", "Lorg/acra/scheduler/SchedulerStarter;", "<init>", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;Lorg/acra/scheduler/SchedulerStarter;)V", "reportLocator", "Lorg/acra/file/ReportLocator;", "fileNameParser", "Lorg/acra/file/CrashReportFileNameParser;", "processReports", "", "isAcraEnabled", "", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nStartupProcessorExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartupProcessorExecutor.kt\norg/acra/startup/StartupProcessorExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 PluginLoader.kt\norg/acra/plugins/PluginLoaderKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,66:1\n1#2:67\n11228#3:68\n11563#3,3:69\n30#4:72\n1869#5,2:73\n15#6,2:75\n*S KotlinDebug\n*F\n+ 1 StartupProcessorExecutor.kt\norg/acra/startup/StartupProcessorExecutor\n*L\n42#1:68\n42#1:69,3\n43#1:72\n43#1:73,2\n49#1:75,2\n*E\n"})
public final class StartupProcessorExecutor {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final SchedulerStarter schedulerStarter;
    @NotNull
    private final ReportLocator reportLocator;
    @NotNull
    private final CrashReportFileNameParser fileNameParser;

    public StartupProcessorExecutor(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull SchedulerStarter schedulerStarter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)schedulerStarter, (String)"schedulerStarter");
        this.context = context;
        this.config = config;
        this.schedulerStarter = schedulerStarter;
        this.reportLocator = new ReportLocator(this.context);
        this.fileNameParser = new CrashReportFileNameParser();
    }

    public final void processReports(boolean isAcraEnabled) {
        Calendar calendar;
        Calendar $this$processReports_u24lambda_u240 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$processReports_u24lambda_u240.add(12, -1);
        Calendar now = calendar;
        new Handler(this.context.getMainLooper()).post(() -> StartupProcessorExecutor.processReports$lambda$6(this, now, isAcraEnabled));
    }

    /*
     * WARNING - void declaration
     */
    private static final void processReports$lambda$6$lambda$5(StartupProcessorExecutor this$0, Calendar $now, boolean $isAcraEnabled) {
        void $this$forEach$iv;
        Iterable $this$loadEnabled$iv;
        Object object;
        File it;
        Object object2;
        File[] $this$mapTo$iv$iv;
        Object $this$map$iv = this$0.reportLocator.getUnapprovedReports();
        boolean $i$f$map = false;
        File[] fileArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((File[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (File item$iv$iv : $this$mapTo$iv$iv) {
            void var12_19 = item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(new Report(it, false));
        }
        $this$map$iv = this$0.reportLocator.getApprovedReports();
        object2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((File[])$this$map$iv).length);
        $i$f$mapTo = false;
        int n = $this$mapTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            File item$iv$iv;
            it = item$iv$iv = $this$mapTo$iv$iv[i];
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new Report(it, true));
        }
        List reports = CollectionsKt.plus((Collection)object2, (Iterable)((List)destination$iv$iv));
        $this$map$iv = this$0.config.getPluginLoader();
        CoreConfiguration config$iv = this$0.config;
        boolean $i$f$loadEnabled = false;
        $this$loadEnabled$iv = $this$loadEnabled$iv.loadEnabled(config$iv, StartupProcessor.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StartupProcessor it2 = (StartupProcessor)element$iv;
            boolean bl = false;
            it2.processReports(this$0.context, this$0.config, reports);
        }
        boolean send = false;
        for (Report report : reports) {
            CrashReportFileNameParser crashReportFileNameParser = this$0.fileNameParser;
            String string = report.getFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!crashReportFileNameParser.getTimestamp(string).before($now)) continue;
            if (report.getDelete()) {
                if (report.getFile().delete()) continue;
                boolean $i$f$warn = false;
                object = ACRA.LOG_TAG;
                object2 = ACRA.log;
                boolean bl = false;
                String string2 = "Could not delete report " + report.getFile();
                object2.w((String)object, string2);
                continue;
            }
            if (report.getApproved()) {
                send = true;
                continue;
            }
            if (!report.getApprove() || !$isAcraEnabled || !new ReportInteractionExecutor(this$0.context, this$0.config).performInteractions(report.getFile())) continue;
            this$0.schedulerStarter.scheduleReports(report.getFile(), false);
        }
        if (send && $isAcraEnabled) {
            this$0.schedulerStarter.scheduleReports(null, false);
        }
    }

    private static final void processReports$lambda$6(StartupProcessorExecutor this$0, Calendar $now, boolean $isAcraEnabled) {
        new Thread(() -> StartupProcessorExecutor.processReports$lambda$6$lambda$5(this$0, $now, $isAcraEnabled)).start();
    }
}

