/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.log.ACRALog;
import org.acra.sender.NullSender;
import org.acra.sender.ReportDistributor;
import org.acra.sender.ReportSender;
import org.acra.util.ToastSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/acra/sender/SendingConductor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "<init>", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "locator", "Lorg/acra/file/ReportLocator;", "sendReports", "", "foreground", "", "extras", "Landroid/os/Bundle;", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nSendingConductor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendingConductor.kt\norg/acra/sender/SendingConductor\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n7#2,2:65\n7#2,2:70\n7#2,2:72\n27#2,2:74\n7#2,2:76\n774#3:67\n865#3,2:68\n*S KotlinDebug\n*F\n+ 1 SendingConductor.kt\norg/acra/sender/SendingConductor\n*L\n25#1:65,2\n29#1:70,2\n56#1:72,2\n60#1:74,2\n62#1:76,2\n27#1:67\n27#1:68,2\n*E\n"})
public final class SendingConductor {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final ReportLocator locator;

    public SendingConductor(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.locator = new ReportLocator(this.context);
    }

    /*
     * WARNING - void declaration
     */
    public final void sendReports(boolean foreground, @NotNull Bundle extras) {
        Object object;
        ACRALog aCRALog;
        String string;
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            object = "About to start sending reports from SenderService";
            aCRALog.d(string, (String)object);
        }
        try {
            CharSequence element$iv$iv2;
            String toast;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ReportSender.Companion.loadSenders(this.context, this.config);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ReportSender it = (ReportSender)element$iv$iv2;
                boolean bl = false;
                if (!(it.requiresForeground() == foreground)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List senderInstances = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            if (senderInstances.isEmpty()) {
                boolean $i$f$debug2 = false;
                if (ACRA.DEV_LOGGING) {
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    object = "No ReportSenders configured - adding NullSender";
                    aCRALog.d(string, (String)object);
                }
                senderInstances.add(new NullSender());
            }
            File[] reports = this.locator.getApprovedReports();
            ReportDistributor reportDistributor = new ReportDistributor(this.context, this.config, senderInstances, extras);
            int reportsSentCount = 0;
            CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
            boolean anyNonSilent = false;
            for (File report : reports) {
                boolean isNonSilent;
                String string2 = report.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                boolean bl = isNonSilent = !fileNameParser.isSilent(string2);
                if (extras.getBoolean("onlySendSilentReports") && isNonSilent) continue;
                anyNonSilent |= isNonSilent;
                if (reportsSentCount >= 5) break;
                if (!reportDistributor.distribute(report)) continue;
                int n = reportsSentCount;
                reportsSentCount = n + 1;
            }
            String string3 = toast = reportsSentCount > 0 ? this.config.getReportSendSuccessToast() : this.config.getReportSendFailureToast();
            if (anyNonSilent && !((element$iv$iv2 = (CharSequence)toast) == null || element$iv$iv2.length() == 0)) {
                boolean $i$f$debug3 = false;
                if (ACRA.DEV_LOGGING) {
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    object = "About to show " + (reportsSentCount > 0 ? "success" : "failure") + " toast";
                    aCRALog.d(string, (String)object);
                }
                new Handler(Looper.getMainLooper()).post(() -> SendingConductor.sendReports$lambda$4(this, toast));
            }
        }
        catch (Exception e) {
            Throwable throwable$iv = e;
            boolean $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            object = "";
            aCRALog.e(string, (String)object, throwable$iv);
        }
        $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            object = "Finished sending reports from SenderService";
            aCRALog.d(string, (String)object);
        }
    }

    private static final void sendReports$lambda$4(SendingConductor this$0, String $toast) {
        ToastSender.sendToast(this$0.context, $toast, 1);
    }
}

