/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.annotation.OpenAPI;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.acra.plugins.PluginLoader;
import org.acra.sender.ReportSenderException;
import org.acra.sender.ReportSenderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bg\u0018\u0000 \f2\u00020\u0001:\u0001\fJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lorg/acra/sender/ReportSender;", "", "send", "", "context", "Landroid/content/Context;", "errorContent", "Lorg/acra/data/CrashReportData;", "extras", "Landroid/os/Bundle;", "requiresForeground", "", "Companion", "acra-core_release"})
@OpenAPI
public interface ReportSender {
    @NotNull
    public static final Companion Companion = org.acra.sender.ReportSender$Companion.$$INSTANCE;

    default public void send(@NotNull Context context, @NotNull CrashReportData errorContent) throws ReportSenderException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
    }

    default public void send(@NotNull Context context, @NotNull CrashReportData errorContent, @NotNull Bundle extras) throws ReportSenderException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        this.send(context, errorContent);
    }

    default public boolean requiresForeground() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lorg/acra/sender/ReportSender$Companion;", "", "<init>", "()V", "loadSenders", "", "Lorg/acra/sender/ReportSender;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "hasForegroundSenders", "", "hasBackgroundSenders", "acra-core_release"})
    @SourceDebugExtension(value={"SMAP\nReportSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportSender.kt\norg/acra/sender/ReportSender$Companion\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n+ 3 PluginLoader.kt\norg/acra/plugins/PluginLoaderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n7#2,2:78\n7#2,2:81\n7#2,2:87\n30#3:80\n1563#4:83\n1634#4,2:84\n1636#4:89\n1761#4,3:90\n1761#4,3:93\n1#5:86\n*S KotlinDebug\n*F\n+ 1 ReportSender.kt\norg/acra/sender/ReportSender$Companion\n*L\n67#1:78,2\n69#1:81,2\n70#1:87,2\n68#1:80\n70#1:83\n70#1:84,2\n70#1:89\n73#1:90,3\n75#1:93,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ReportSender> loadSenders(@NotNull Context context, @NotNull CoreConfiguration config) {
            void $this$mapTo$iv$iv;
            void $this$loadEnabled$iv;
            Object object;
            Object object2;
            String string;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string = ACRA.LOG_TAG;
                object2 = ACRA.log;
                boolean bl = false;
                object = "Using PluginLoader to find ReportSender factories";
                object2.d(string, (String)object);
            }
            PluginLoader bl = config.getPluginLoader();
            CoreConfiguration config$iv = config;
            boolean $i$f$loadEnabled22 = false;
            List<ReportSenderFactory> factories = $this$loadEnabled$iv.loadEnabled(config$iv, ReportSenderFactory.class);
            boolean $i$f$debug2 = false;
            if (ACRA.DEV_LOGGING) {
                string = ACRA.LOG_TAG;
                object2 = ACRA.log;
                boolean bl2 = false;
                object = "reportSenderFactories : " + factories;
                object2.d(string, (String)object);
            }
            Iterable $this$map$iv = factories;
            boolean $i$f$map = false;
            Iterable $i$f$loadEnabled22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReportSender reportSender;
                ReportSenderFactory reportSenderFactory = (ReportSenderFactory)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl3 = false;
                ReportSender it2 = reportSender = it.create(context, config);
                boolean bl4 = false;
                boolean $i$f$debug3 = false;
                if (ACRA.DEV_LOGGING) {
                    String string2 = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl5 = false;
                    String string3 = "Adding reportSender : " + it2;
                    aCRALog.d(string2, string3);
                }
                object2.add(reportSender);
            }
            return (List)destination$iv$iv;
        }

        public final boolean hasForegroundSenders(@NotNull Context context, @NotNull CoreConfiguration config) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Iterable $this$any$iv = this.loadSenders(context, config);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ReportSender it = (ReportSender)element$iv;
                        boolean bl2 = false;
                        if (!it.requiresForeground()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean hasBackgroundSenders(@NotNull Context context, @NotNull CoreConfiguration config) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Iterable $this$any$iv = this.loadSenders(context, config);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ReportSender it = (ReportSender)element$iv;
                        boolean bl2 = false;
                        if (!(!it.requiresForeground())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

