/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.log.ACRALog;
import org.acra.scheduler.SenderScheduler;
import org.acra.sender.JobSenderService;
import org.acra.sender.LegacySenderService;
import org.acra.sender.ReportSender;
import org.acra.sender.SendingConductor;
import org.acra.util.BundleKt;
import org.acra.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0015J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/acra/scheduler/DefaultSenderScheduler;", "Lorg/acra/scheduler/SenderScheduler;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "<init>", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "scheduleReportSending", "", "onlySendSilentReports", "", "configureJob", "job", "Landroid/app/job/JobInfo$Builder;", "configureExtras", "extras", "Landroid/os/Bundle;", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nDefaultSenderScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSenderScheduler.kt\norg/acra/scheduler/DefaultSenderScheduler\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,86:1\n27#2,2:87\n*S KotlinDebug\n*F\n+ 1 DefaultSenderScheduler.kt\norg/acra/scheduler/DefaultSenderScheduler\n*L\n56#1:87,2\n*E\n"})
public class DefaultSenderScheduler
implements SenderScheduler {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;

    public DefaultSenderScheduler(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
    }

    @Override
    public void scheduleReportSending(boolean onlySendSilentReports) {
        Bundle extras = new Bundle();
        extras.putString("acraConfig", IOUtils.INSTANCE.serialize(this.config));
        extras.putBoolean("onlySendSilentReports", onlySendSilentReports);
        this.configureExtras(extras);
        if (ReportSender.Companion.hasBackgroundSenders(this.context, this.config)) {
            if (Build.VERSION.SDK_INT >= 22) {
                Object object = this.context.getSystemService("jobscheduler");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.job.JobScheduler");
                JobScheduler scheduler = (JobScheduler)object;
                JobInfo.Builder builder = new JobInfo.Builder(0, new ComponentName(this.context, JobSenderService.class)).setExtras(BundleKt.toPersistableBundle(extras));
                Intrinsics.checkNotNull((Object)builder);
                this.configureJob(builder);
                try {
                    Integer n = scheduler.schedule(builder.build());
                }
                catch (IllegalArgumentException e) {
                    Throwable throwable$iv = e;
                    boolean $i$f$error = false;
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "Failed to schedule Sender Service. No reports can be sent.";
                    aCRALog.e(string, string2, throwable$iv);
                    Unit unit = Unit.INSTANCE;
                }
            } else {
                Intent intent = new Intent();
                intent.putExtras(extras);
                intent.setComponent(new ComponentName(this.context, LegacySenderService.class));
                this.context.startService(intent);
            }
        }
        if (ReportSender.Companion.hasForegroundSenders(this.context, this.config)) {
            new SendingConductor(this.context, this.config).sendReports(true, extras);
        }
    }

    @RequiresApi(api=21)
    protected void configureJob(@NotNull JobInfo.Builder job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        job.setOverrideDeadline(0L);
    }

    protected final void configureExtras(@NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
    }
}

