/*
 * Decompiled with CFR 0.152.
 */
package org.acra.prefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.acra.config.CoreConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/acra/prefs/SharedPreferencesFactory;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "<init>", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "create", "Landroid/content/SharedPreferences;", "Companion", "acra-core_release"})
public final class SharedPreferencesFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;

    public SharedPreferencesFactory(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
    }

    @NotNull
    public final SharedPreferences create() {
        SharedPreferences sharedPreferences;
        if (this.config.getSharedPreferencesName() != null) {
            SharedPreferences sharedPreferences2 = this.context.getSharedPreferences(this.config.getSharedPreferencesName(), 0);
            Intrinsics.checkNotNull((Object)sharedPreferences2);
            sharedPreferences = sharedPreferences2;
        } else {
            SharedPreferences sharedPreferences3 = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
            Intrinsics.checkNotNull((Object)sharedPreferences3);
            sharedPreferences = sharedPreferences3;
        }
        return sharedPreferences;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/acra/prefs/SharedPreferencesFactory$Companion;", "", "<init>", "()V", "shouldEnableACRA", "", "prefs", "Landroid/content/SharedPreferences;", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldEnableACRA(@NotNull SharedPreferences prefs) {
            Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
            boolean enableAcra = true;
            try {
                boolean disableAcra = prefs.getBoolean("acra.disable", false);
                enableAcra = prefs.getBoolean("acra.enable", !disableAcra);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return enableAcra;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

