/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import com.google.auto.service.AutoService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.ApplicationStartupCollector;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/acra/collector/TimeCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "Lorg/acra/collector/ApplicationStartupCollector;", "<init>", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "appStartDate", "Ljava/util/Calendar;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectApplicationStartUp", "shouldCollect", "", "getTimeString", "", "time", "acra-core_release"})
@AutoService(value={Collector.class})
public class TimeCollector
extends BaseReportFieldCollector
implements ApplicationStartupCollector {
    @NotNull
    private final SimpleDateFormat dateFormat;
    @Nullable
    private Calendar appStartDate;

    public TimeCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.USER_APP_START_DATE, ReportField.USER_CRASH_DATE};
        super(reportFieldArray);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ", Locale.ENGLISH);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) {
        Calendar time;
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                calendar = this.appStartDate;
                break;
            }
            case 2: {
                calendar = new GregorianCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Calendar calendar2 = time = calendar;
        Intrinsics.checkNotNull((Object)calendar2);
        target.put(reportField, this.getTimeString(calendar2));
    }

    @Override
    public void collectApplicationStartUp(@NotNull Context context, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.getReportContent().contains((Object)ReportField.USER_APP_START_DATE)) {
            this.appStartDate = new GregorianCalendar();
        }
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)collect), (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return collect == ReportField.USER_CRASH_DATE || super.shouldCollect(context, config, collect, reportBuilder);
    }

    private String getTimeString(Calendar time) {
        String string = this.dateFormat.format(time.getTimeInMillis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportField.values().length];
            try {
                nArray[ReportField.USER_APP_START_DATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.USER_CRASH_DATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

