/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0012J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0012\u00a8\u0006\u0019"}, d2={"Lorg/acra/collector/SettingsCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "<init>", "()V", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "collectSettings", "Lorg/json/JSONObject;", "settings", "Ljava/lang/Class;", "isAuthorized", "", "key", "Ljava/lang/reflect/Field;", "Companion", "acra-core_release"})
@AutoService(value={Collector.class})
@SourceDebugExtension(value={"SMAP\nSettingsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsCollector.kt\norg/acra/collector/SettingsCollector\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,92:1\n19#2,2:93\n*S KotlinDebug\n*F\n+ 1 SettingsCollector.kt\norg/acra/collector/SettingsCollector\n*L\n70#1:93,2\n*E\n"})
public class SettingsCollector
extends BaseReportFieldCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ERROR = "Error: ";

    public SettingsCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.SETTINGS_SYSTEM, ReportField.SETTINGS_SECURE, ReportField.SETTINGS_GLOBAL};
        super(reportFieldArray);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                target.put(ReportField.SETTINGS_SYSTEM, this.collectSettings(context, config, Settings.System.class));
                break;
            }
            case 2: {
                target.put(ReportField.SETTINGS_SECURE, this.collectSettings(context, config, Settings.Secure.class));
                break;
            }
            case 3: {
                target.put(ReportField.SETTINGS_GLOBAL, Build.VERSION.SDK_INT >= 17 ? this.collectSettings(context, config, Settings.Global.class) : null);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private JSONObject collectSettings(Context context, CoreConfiguration config, Class<?> settings) throws NoSuchMethodException {
        JSONObject result = new JSONObject();
        Object[] keys = settings.getFields();
        Object object = new Class[]{ContentResolver.class, String.class};
        Method getString = settings.getMethod("getString", (Class<?>)object);
        object = ArrayIteratorKt.iterator((Object[])keys);
        while (object.hasNext()) {
            Field key = (Field)object.next();
            if (key.isAnnotationPresent(Deprecated.class) || !Intrinsics.areEqual(key.getType(), String.class) || !this.isAuthorized(config, key)) continue;
            try {
                Object[] objectArray = new Object[]{context.getContentResolver(), key.get(null)};
                Object value = getString.invoke(null, objectArray);
                if (value == null) continue;
                result.put(key.getName(), value);
            }
            catch (Exception e) {
                Throwable throwable$iv = e;
                boolean $i$f$warn = false;
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = ERROR;
                aCRALog.w(string, string2, throwable$iv);
            }
        }
        return result;
    }

    private boolean isAuthorized(CoreConfiguration config, Field key) {
        block4: {
            block3: {
                if (key == null) break block3;
                String string = key.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"WIFI_AP", (boolean)false, (int)2, null)) break block4;
            }
            return false;
        }
        for (String regex : config.getExcludeMatchingSettingsKeys()) {
            String string = key.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            CharSequence charSequence = string;
            if (!new Regex(regex).matches(charSequence)) continue;
            return false;
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/acra/collector/SettingsCollector$Companion;", "", "<init>", "()V", "ERROR", "", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportField.values().length];
            try {
                nArray[ReportField.SETTINGS_SYSTEM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.SETTINGS_SECURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.SETTINGS_GLOBAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

