/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.acra.util.StreamReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0012J\b\u0010\u0016\u001a\u00020\u0015H\u0012\u00a8\u0006\u0017"}, d2={"Lorg/acra/collector/MemoryInfoCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "<init>", "()V", "shouldCollect", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "collect", "Lorg/acra/ReportField;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "", "reportField", "target", "Lorg/acra/data/CrashReportData;", "collectMemInfo", "", "getAvailableInternalMemorySize", "", "getTotalInternalMemorySize", "acra-core_release"})
@AutoService(value={Collector.class})
@SourceDebugExtension(value={"SMAP\nMemoryInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryInfoCollector.kt\norg/acra/collector/MemoryInfoCollector\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,105:1\n37#2:106\n36#2,3:107\n27#3,2:110\n*S KotlinDebug\n*F\n+ 1 MemoryInfoCollector.kt\norg/acra/collector/MemoryInfoCollector\n*L\n64#1:106\n64#1:107,3\n67#1:110,2\n*E\n"})
public class MemoryInfoCollector
extends BaseReportFieldCollector {
    public MemoryInfoCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.DUMPSYS_MEMINFO, ReportField.TOTAL_MEM_SIZE, ReportField.AVAILABLE_MEM_SIZE};
        super(reportFieldArray);
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)collect), (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && !(reportBuilder.getException() instanceof OutOfMemoryError);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                target.put(ReportField.DUMPSYS_MEMINFO, this.collectMemInfo());
                break;
            }
            case 2: {
                target.put(ReportField.TOTAL_MEM_SIZE, this.getTotalInternalMemorySize());
                break;
            }
            case 3: {
                target.put(ReportField.AVAILABLE_MEM_SIZE, this.getAvailableInternalMemorySize());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private String collectMemInfo() {
        String string;
        try {
            List commandLine = new ArrayList();
            commandLine.add("dumpsys");
            commandLine.add("meminfo");
            commandLine.add(String.valueOf(android.os.Process.myPid()));
            Collection $this$toTypedArray$iv = commandLine;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]));
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            string = new StreamReader(inputStream, 0, 0, null, 14, null).read();
        }
        catch (IOException e) {
            Throwable throwable$iv = e;
            boolean $i$f$error = false;
            String string2 = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "MemoryInfoCollector.meminfo could not retrieve data";
            aCRALog.e(string2, string3, throwable$iv);
            string = null;
        }
        return string;
    }

    private long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        return Build.VERSION.SDK_INT >= 18 ? stat.getBlockSizeLong() * stat.getAvailableBlocksLong() : (long)stat.getBlockSize() * (long)stat.getAvailableBlocks();
    }

    private long getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        return Build.VERSION.SDK_INT >= 18 ? stat.getBlockSizeLong() * stat.getBlockCountLong() : (long)stat.getBlockSize() * (long)stat.getBlockCount();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportField.values().length];
            try {
                nArray[ReportField.DUMPSYS_MEMINFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.TOTAL_MEM_SIZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.AVAILABLE_MEM_SIZE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

