/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.SparseArray;
import com.google.auto.service.AutoService;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 *2\u00020\u0001:\u0002)*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u0013H\u0012J\b\u0010!\u001a\u00020\"H\u0013J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0006H\u0013J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010$\u001a\u00020%H\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lorg/acra/collector/MediaCodecListCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "<init>", "()V", "mColorFormatValues", "Landroid/util/SparseArray;", "", "mAVCLevelValues", "mAVCProfileValues", "mH263LevelValues", "mH263ProfileValues", "mMPEG4LevelValues", "mMPEG4ProfileValues", "mAACProfileValues", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "shouldCollect", "", "prepare", "collectMediaCodecList", "Lorg/json/JSONObject;", "collectCapabilitiesForType", "codecInfo", "Landroid/media/MediaCodecInfo;", "type", "identifyCodecType", "Lorg/acra/collector/MediaCodecListCollector$CodecType;", "CodecType", "Companion", "acra-core_release"})
@AutoService(value={Collector.class})
@SourceDebugExtension(value={"SMAP\nMediaCodecListCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaCodecListCollector.kt\norg/acra/collector/MediaCodecListCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,226:1\n1563#2:227\n1634#2,3:228\n37#3:231\n36#3,3:232\n*S KotlinDebug\n*F\n+ 1 MediaCodecListCollector.kt\norg/acra/collector/MediaCodecListCollector\n*L\n120#1:227\n120#1:228,3\n120#1:231\n120#1:232,3\n*E\n"})
public class MediaCodecListCollector
extends BaseReportFieldCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArray<String> mColorFormatValues;
    @NotNull
    private final SparseArray<String> mAVCLevelValues;
    @NotNull
    private final SparseArray<String> mAVCProfileValues;
    @NotNull
    private final SparseArray<String> mH263LevelValues;
    @NotNull
    private final SparseArray<String> mH263ProfileValues;
    @NotNull
    private final SparseArray<String> mMPEG4LevelValues;
    @NotNull
    private final SparseArray<String> mMPEG4ProfileValues;
    @NotNull
    private final SparseArray<String> mAACProfileValues;
    @NotNull
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    @NotNull
    private static final String[] MPEG4_TYPES;
    @NotNull
    private static final String[] AVC_TYPES;
    @NotNull
    private static final String[] H263_TYPES;
    @NotNull
    private static final String[] AAC_TYPES;

    public MediaCodecListCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.MEDIA_CODEC_LIST};
        super(reportFieldArray);
        this.mColorFormatValues = new SparseArray();
        this.mAVCLevelValues = new SparseArray();
        this.mAVCProfileValues = new SparseArray();
        this.mH263LevelValues = new SparseArray();
        this.mH263ProfileValues = new SparseArray();
        this.mMPEG4LevelValues = new SparseArray();
        this.mMPEG4ProfileValues = new SparseArray();
        this.mAACProfileValues = new SparseArray();
    }

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.put(ReportField.MEDIA_CODEC_LIST, this.collectMediaCodecList());
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)collect), (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && Build.VERSION.SDK_INT >= 16;
    }

    private void prepare() {
        try {
            Class<?> codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            Iterator iterator = ArrayIteratorKt.iterator((Object[])codecCapabilitiesClass.getFields());
            while (iterator.hasNext()) {
                Field f = (Field)iterator.next();
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)COLOR_FORMAT_PREFIX, (boolean)false, (int)2, null)) continue;
                this.mColorFormatValues.put(f.getInt(null), (Object)f.getName());
            }
            Class<?> codecProfileLevelClass = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])codecProfileLevelClass.getFields());
            while (iterator2.hasNext()) {
                Field f = (Field)iterator2.next();
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string, (String)"AVCLevel", (boolean)false, (int)2, null)) {
                    this.mAVCLevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string2 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string2, (String)"AVCProfile", (boolean)false, (int)2, null)) {
                    this.mAVCProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string3 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string3, (String)"H263Level", (boolean)false, (int)2, null)) {
                    this.mH263LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string4 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string4, (String)"H263Profile", (boolean)false, (int)2, null)) {
                    this.mH263ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string5 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string5, (String)"MPEG4Level", (boolean)false, (int)2, null)) {
                    this.mMPEG4LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string6 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string6, (String)"MPEG4Profile", (boolean)false, (int)2, null)) {
                    this.mMPEG4ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                String string7 = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string7, (String)"AAC", (boolean)false, (int)2, null)) continue;
                this.mAACProfileValues.put(f.getInt(null), (Object)f.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=16)
    private JSONObject collectMediaCodecList() throws JSONException {
        MediaCodecInfo[] mediaCodecInfoArray;
        this.prepare();
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecInfo[] mediaCodecInfoArray2 = new MediaCodecList(1).getCodecInfos();
            Intrinsics.checkNotNull((Object)mediaCodecInfoArray2);
            mediaCodecInfoArray = mediaCodecInfoArray2;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)MediaCodecList.getCodecCount());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MediaCodecList.getCodecInfoAt((int)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            mediaCodecInfoArray = thisCollection$iv.toArray(new MediaCodecInfo[0]);
        }
        MediaCodecInfo[] infos = mediaCodecInfoArray;
        JSONObject result = new JSONObject();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            MediaCodecInfo codecInfo = infos[i];
            JSONObject codec = new JSONObject();
            MediaCodecInfo mediaCodecInfo = codecInfo;
            Intrinsics.checkNotNull((Object)mediaCodecInfo);
            Object[] supportedTypes = mediaCodecInfo.getSupportedTypes();
            codec.put("name", (Object)codecInfo.getName()).put("isEncoder", codecInfo.isEncoder());
            JSONObject supportedTypesJson = new JSONObject();
            Iterator iterator = ArrayIteratorKt.iterator((Object[])supportedTypes);
            while (iterator.hasNext()) {
                String type = (String)iterator.next();
                Intrinsics.checkNotNull((Object)type);
                supportedTypesJson.put(type, (Object)this.collectCapabilitiesForType(codecInfo, type));
            }
            codec.put("supportedTypes", (Object)supportedTypesJson);
            result.put(String.valueOf(i), (Object)codec);
        }
        return result;
    }

    @TargetApi(value=16)
    private JSONObject collectCapabilitiesForType(MediaCodecInfo codecInfo, String type) throws JSONException {
        JSONObject result = new JSONObject();
        MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
        int[] colorFormats = codecCapabilities.colorFormats;
        Intrinsics.checkNotNull((Object)colorFormats);
        if (!(colorFormats.length == 0)) {
            JSONArray colorFormatsJson = new JSONArray();
            for (int colorFormat : colorFormats) {
                colorFormatsJson.put(this.mColorFormatValues.get(colorFormat));
            }
            result.put("colorFormats", (Object)colorFormatsJson);
        }
        CodecType codecType = this.identifyCodecType(codecInfo);
        Object[] codecProfileLevels = codecCapabilities.profileLevels;
        Intrinsics.checkNotNull((Object)codecProfileLevels);
        if (!(codecProfileLevels.length == 0)) {
            JSONArray profileLevels = new JSONArray();
            Iterator iterator = ArrayIteratorKt.iterator((Object[])codecProfileLevels);
            while (iterator.hasNext()) {
                MediaCodecInfo.CodecProfileLevel codecProfileLevel = (MediaCodecInfo.CodecProfileLevel)iterator.next();
                int profileValue = codecProfileLevel.profile;
                int levelValue = codecProfileLevel.level;
                if (codecType == null) {
                    profileLevels.put(profileValue + 45 + levelValue);
                    break;
                }
                CodecType codecType2 = codecType;
                switch (WhenMappings.$EnumSwitchMapping$0[codecType2.ordinal()]) {
                    case 1: {
                        JSONArray jSONArray = profileLevels.put((Object)("" + profileValue + this.mAVCProfileValues.get(profileValue) + "-" + this.mAVCLevelValues.get(levelValue)));
                        break;
                    }
                    case 2: {
                        JSONArray jSONArray = profileLevels.put((Object)(this.mH263ProfileValues.get(profileValue) + "-" + this.mH263LevelValues.get(levelValue)));
                        break;
                    }
                    case 3: {
                        JSONArray jSONArray = profileLevels.put((Object)(this.mMPEG4ProfileValues.get(profileValue) + "-" + this.mMPEG4LevelValues.get(levelValue)));
                        break;
                    }
                    case 4: {
                        JSONArray jSONArray = profileLevels.put(this.mAACProfileValues.get(profileValue));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            result.put("profileLevels", (Object)profileLevels);
        }
        return result;
    }

    @TargetApi(value=16)
    private CodecType identifyCodecType(MediaCodecInfo codecInfo) {
        String string = codecInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        for (String token : AVC_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.AVC;
        }
        for (String token : H263_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.H263;
        }
        for (String token : MPEG4_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.MPEG4;
        }
        for (String token : AAC_TYPES) {
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)token, (boolean)false, (int)2, null)) continue;
            return CodecType.AAC;
        }
        return null;
    }

    static {
        String[] stringArray = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
        MPEG4_TYPES = stringArray;
        stringArray = new String[]{"avc", "h264", "AVC", "H264"};
        AVC_TYPES = stringArray;
        stringArray = new String[]{"h263", "H263"};
        H263_TYPES = stringArray;
        stringArray = new String[]{"aac", "AAC"};
        AAC_TYPES = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/acra/collector/MediaCodecListCollector$CodecType;", "", "<init>", "(Ljava/lang/String;I)V", "AVC", "H263", "MPEG4", "AAC", "acra-core_release"})
    private static final class CodecType
    extends Enum<CodecType> {
        public static final /* enum */ CodecType AVC = new CodecType();
        public static final /* enum */ CodecType H263 = new CodecType();
        public static final /* enum */ CodecType MPEG4 = new CodecType();
        public static final /* enum */ CodecType AAC = new CodecType();
        private static final /* synthetic */ CodecType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CodecType[] values() {
            return (CodecType[])$VALUES.clone();
        }

        public static CodecType valueOf(String value) {
            return Enum.valueOf(CodecType.class, value);
        }

        @NotNull
        public static EnumEntries<CodecType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = codecTypeArray = new CodecType[]{CodecType.AVC, CodecType.H263, CodecType.MPEG4, CodecType.AAC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lorg/acra/collector/MediaCodecListCollector$Companion;", "", "<init>", "()V", "COLOR_FORMAT_PREFIX", "", "MPEG4_TYPES", "", "[Ljava/lang/String;", "AVC_TYPES", "H263_TYPES", "AAC_TYPES", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodecType.values().length];
            try {
                nArray[CodecType.AVC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodecType.H263.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodecType.MPEG4.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodecType.AAC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

