/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import com.google.auto.service.AutoService;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.acra.util.StreamReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/acra/collector/LogFileCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "<init>", "()V", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "acra-core_release"})
@AutoService(value={Collector.class})
@SourceDebugExtension(value={"SMAP\nLogFileCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFileCollector.kt\norg/acra/collector/LogFileCollector\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,49:1\n15#2,2:50\n*S KotlinDebug\n*F\n+ 1 LogFileCollector.kt\norg/acra/collector/LogFileCollector\n*L\n46#1:50,2\n*E\n"})
public class LogFileCollector
extends BaseReportFieldCollector {
    public LogFileCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.APPLICATION_LOG};
        super(reportFieldArray);
    }

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (config.getApplicationLogFile() != null) {
            target.put(ReportField.APPLICATION_LOG, new StreamReader(config.getApplicationLogFileDir().getFile(context, config.getApplicationLogFile())).setLimit(config.getApplicationLogFileLines()).read());
        } else {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = ReportField.APPLICATION_LOG + " was enabled but applicationLogFile was not set. No application log will be recorded.";
            aCRALog.w(string, string2);
        }
    }
}

