/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.DropBoxManager;
import com.google.auto.service.AutoService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.SystemServices;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/acra/collector/DropBoxCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "<init>", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "shouldCollect", "", "Companion", "acra-core_release"})
@AutoService(value={Collector.class})
@SourceDebugExtension(value={"SMAP\nDropBoxCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropBoxCollector.kt\norg/acra/collector/DropBoxCollector\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,111:1\n19#2,2:112\n*S KotlinDebug\n*F\n+ 1 DropBoxCollector.kt\norg/acra/collector/DropBoxCollector\n*L\n92#1:112,2\n*E\n"})
public class DropBoxCollector
extends BaseReportFieldCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private static final String[] SYSTEM_TAGS;

    public DropBoxCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.DROPBOX};
        super(reportFieldArray);
        this.dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.getDefault());
    }

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.FIRST;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        List additionalTags;
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DropBoxManager dropbox = SystemServices.getDropBoxManager(context);
        Calendar calendar = Calendar.getInstance();
        calendar.roll(12, -config.getDropboxCollectionMinutes());
        long time = calendar.getTimeInMillis();
        this.dateFormat.format(calendar.getTime());
        List tags = new ArrayList();
        if (config.getIncludeDropBoxSystemTags()) {
            CollectionsKt.addAll((Collection)tags, (Object[])SYSTEM_TAGS);
        }
        if (!((Collection)(additionalTags = CollectionsKt.toList((Iterable)config.getAdditionalDropBoxTags()))).isEmpty()) {
            tags.addAll(additionalTags);
        }
        if (!((Collection)tags).isEmpty()) {
            JSONObject dropboxContent = new JSONObject();
            for (String tag : tags) {
                JSONObject jSONObject;
                StringBuilder builder = new StringBuilder();
                DropBoxManager.Entry entry = dropbox.getNextEntry(tag, time);
                if (entry == null) {
                    builder.append("Nothing.").append('\n');
                    continue;
                }
                while (entry != null) {
                    long msec = entry.getTimeMillis();
                    calendar.setTimeInMillis(msec);
                    builder.append('@').append(this.dateFormat.format(calendar.getTime())).append('\n');
                    String text = entry.getText(500);
                    StringBuilder stringBuilder = text != null ? builder.append("Text: ").append(text).append('\n') : builder.append("Not Text!").append('\n');
                    entry.close();
                    entry = dropbox.getNextEntry(tag, msec);
                }
                try {
                    jSONObject = dropboxContent.put(tag, (Object)builder.toString());
                }
                catch (JSONException e) {
                    Throwable throwable$iv = e;
                    boolean $i$f$warn = false;
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "Failed to collect data for tag " + tag;
                    aCRALog.w(string, string2, throwable$iv);
                    jSONObject = Unit.INSTANCE;
                }
            }
            target.put(ReportField.DROPBOX, dropboxContent);
        }
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)collect), (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && (Build.VERSION.SDK_INT >= 16 || new PackageManagerWrapper(context).hasPermission("android.permission.READ_LOGS")) && new SharedPreferencesFactory(context, config).create().getBoolean("acra.syslog.enable", true);
    }

    static {
        String[] stringArray = new String[]{"system_app_anr", "system_app_wtf", "system_app_crash", "system_server_anr", "system_server_wtf", "system_server_crash", "BATTERY_DISCHARGE_INFO", "SYSTEM_RECOVERY_LOG", "SYSTEM_BOOT", "SYSTEM_LAST_KMSG", "APANIC_CONSOLE", "APANIC_THREADS", "SYSTEM_RESTART", "SYSTEM_TOMBSTONE", "data_app_strictmode"};
        SYSTEM_TAGS = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/acra/collector/DropBoxCollector$Companion;", "", "<init>", "()V", "SYSTEM_TAGS", "", "", "[Ljava/lang/String;", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

