/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import com.google.auto.service.AutoService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.SystemServices;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Lorg/acra/collector/DeviceIdCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "<init>", "()V", "shouldCollect", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "collect", "Lorg/acra/ReportField;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "", "reportField", "target", "Lorg/acra/data/CrashReportData;", "acra-core_release"})
@AutoService(value={Collector.class})
public class DeviceIdCollector
extends BaseReportFieldCollector {
    public DeviceIdCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.DEVICE_ID};
        super(reportFieldArray);
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)collect), (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && new SharedPreferencesFactory(context, config).create().getBoolean("acra.deviceid.enable", true) && new PackageManagerWrapper(context).hasPermission("android.permission.READ_PHONE_STATE");
    }

    @Override
    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String deviceId = Build.VERSION.SDK_INT <= 28 ? SystemServices.getTelephonyManager(context).getDeviceId() : null;
        target.put(ReportField.DEVICE_ID, deviceId);
    }
}

