/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.Collector;
import org.acra.collector.CollectorException;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u000e\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0013H&R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/acra/collector/BaseReportFieldCollector;", "Lorg/acra/collector/Collector;", "reportFields", "", "Lorg/acra/ReportField;", "<init>", "([Lorg/acra/ReportField;)V", "[Lorg/acra/ReportField;", "shouldCollect", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "collect", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "", "crashReportData", "Lorg/acra/data/CrashReportData;", "reportField", "target", "acra-core_release"})
public abstract class BaseReportFieldCollector
implements Collector {
    @NotNull
    private final ReportField[] reportFields;

    public BaseReportFieldCollector(ReportField ... reportFields) {
        Intrinsics.checkNotNullParameter((Object)reportFields, (String)"reportFields");
        this.reportFields = reportFields;
    }

    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)collect), (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return config.getReportContent().contains((Object)collect);
    }

    @Override
    public void collect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData crashReportData) throws CollectorException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)crashReportData, (String)"crashReportData");
        for (ReportField field : this.reportFields) {
            try {
                if (!this.shouldCollect(context, config, field, reportBuilder)) continue;
                this.collect(field, context, config, reportBuilder, crashReportData);
            }
            catch (Exception t) {
                crashReportData.put(field, (String)null);
                throw new CollectorException("Error while retrieving " + field.name() + " data:" + t.getMessage(), t);
            }
        }
    }

    public abstract void collect(@NotNull ReportField var1, @NotNull Context var2, @NotNull CoreConfiguration var3, @NotNull ReportBuilder var4, @NotNull CrashReportData var5) throws Exception;
}

