/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.acra.ErrorReporter;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.CoreConfiguration;
import org.acra.config.CoreConfigurationBuilder;
import org.acra.log.ACRALog;
import org.acra.log.AndroidLogDelegate;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.reporter.ErrorReporterImpl;
import org.acra.util.StreamReader;
import org.acra.util.StubCreator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0005H\u0007J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u001e\u001a\u00020\u0005H\u0007J\b\u0010#\u001a\u00020\u0005H\u0007J\n\u0010$\u001a\u0004\u0018\u00010\u0007H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lorg/acra/ACRA;", "", "<init>", "()V", "DEV_LOGGING", "", "LOG_TAG", "", "log", "Lorg/acra/log/ACRALog;", "ACRA_PRIVATE_PROCESS_NAME", "PREF_DISABLE_ACRA", "PREF_ENABLE_ACRA", "PREF_ENABLE_SYSTEM_LOGS", "PREF_ENABLE_DEVICE_ID", "PREF_USER_EMAIL_ADDRESS", "PREF_ALWAYS_ACCEPT", "PREF_LAST_VERSION_NR", "value", "Lorg/acra/ErrorReporter;", "errorReporter", "getErrorReporter$annotations", "getErrorReporter", "()Lorg/acra/ErrorReporter;", "init", "", "app", "Landroid/app/Application;", "builder", "Lorg/acra/config/CoreConfigurationBuilder;", "checkReportsOnApplicationStart", "config", "Lorg/acra/config/CoreConfiguration;", "isInitialised", "()Z", "isACRASenderServiceProcess", "currentProcessName", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nACRA.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ACRA.kt\norg/acra/ACRA\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,204:1\n19#2,2:205\n7#2,2:207\n15#2,2:209\n15#2,2:211\n7#2,2:213\n11#2,2:215\n7#2,2:217\n106#3:219\n78#3,22:220\n*S KotlinDebug\n*F\n+ 1 ACRA.kt\norg/acra/ACRA\n*L\n128#1:205,2\n150#1:207,2\n157#1:209,2\n160#1:211,2\n161#1:213,2\n170#1:215,2\n194#1:217,2\n200#1:219\n200#1:220,22\n*E\n"})
public final class ACRA {
    @NotNull
    public static final ACRA INSTANCE = new ACRA();
    @JvmField
    public static boolean DEV_LOGGING;
    @JvmField
    @NotNull
    public static final String LOG_TAG;
    @JvmField
    @NotNull
    public static ACRALog log;
    @NotNull
    private static final String ACRA_PRIVATE_PROCESS_NAME = ":acra";
    @NotNull
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    @NotNull
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    @NotNull
    public static final String PREF_ENABLE_SYSTEM_LOGS = "acra.syslog.enable";
    @NotNull
    public static final String PREF_ENABLE_DEVICE_ID = "acra.deviceid.enable";
    @NotNull
    public static final String PREF_USER_EMAIL_ADDRESS = "acra.user.email";
    @NotNull
    public static final String PREF_ALWAYS_ACCEPT = "acra.alwaysaccept";
    @NotNull
    public static final String PREF_LAST_VERSION_NR = "acra.lastVersionNr";
    @NotNull
    private static ErrorReporter errorReporter;

    private ACRA() {
    }

    @NotNull
    public static final ErrorReporter getErrorReporter() {
        return errorReporter;
    }

    @JvmStatic
    public static /* synthetic */ void getErrorReporter$annotations() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfigurationBuilder builder, boolean checkReportsOnApplicationStart) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        try {
            ACRA.init(app, builder.build(), checkReportsOnApplicationStart);
        }
        catch (ACRAConfigurationException e) {
            Throwable throwable$iv = e;
            boolean $i$f$warn = false;
            String string = LOG_TAG;
            ACRALog aCRALog = log;
            boolean bl = false;
            String string2 = "Configuration Error - ACRA not started.";
            aCRALog.w(string, string2, throwable$iv);
        }
    }

    public static /* synthetic */ void init$default(Application application, CoreConfigurationBuilder coreConfigurationBuilder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            coreConfigurationBuilder = new CoreConfigurationBuilder();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        ACRA.init(application, coreConfigurationBuilder, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfiguration config, boolean checkReportsOnApplicationStart) {
        boolean $i$f$warn;
        boolean supportedAndroidVersion;
        Object object;
        ACRALog aCRALog;
        String string;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean senderServiceProcess = INSTANCE.isACRASenderServiceProcess();
        if (senderServiceProcess) {
            boolean $i$f$debug = false;
            if (DEV_LOGGING) {
                string = LOG_TAG;
                aCRALog = log;
                boolean bl = false;
                object = "Not initialising ACRA to listen for uncaught Exceptions as this is the SendWorker process and we only send reports, we don't capture them to avoid infinite loops";
                aCRALog.d(string, (String)object);
            }
        }
        boolean bl = supportedAndroidVersion = Build.VERSION.SDK_INT >= 14;
        if (!supportedAndroidVersion) {
            $i$f$warn = false;
            string = LOG_TAG;
            aCRALog = log;
            boolean bl2 = false;
            object = "ACRA 5.1.0+ requires ICS or greater. ACRA is disabled and will NOT catch crashes or send messages.";
            aCRALog.w(string, (String)object);
        }
        if (INSTANCE.isInitialised()) {
            $i$f$warn = false;
            string = LOG_TAG;
            aCRALog = log;
            boolean bl3 = false;
            object = "ACRA#init called more than once. This might have unexpected side effects. Doing this outside of tests is discouraged.";
            aCRALog.w(string, (String)object);
            boolean $i$f$debug = false;
            if (DEV_LOGGING) {
                string = LOG_TAG;
                aCRALog = log;
                boolean bl4 = false;
                object = "Removing old ACRA config...";
                aCRALog.d(string, (String)object);
            }
            ErrorReporter errorReporter = ACRA.errorReporter;
            Intrinsics.checkNotNull((Object)errorReporter, (String)"null cannot be cast to non-null type org.acra.reporter.ErrorReporterImpl");
            ((ErrorReporterImpl)errorReporter).unregister();
            ACRA.errorReporter = StubCreator.INSTANCE.createErrorReporterStub();
        }
        SharedPreferences prefs = new SharedPreferencesFactory((Context)app, config).create();
        if (!senderServiceProcess) {
            boolean enableAcra = supportedAndroidVersion && SharedPreferencesFactory.Companion.shouldEnableACRA(prefs);
            boolean $i$f$info = false;
            string = LOG_TAG;
            aCRALog = log;
            boolean bl5 = false;
            object = "ACRA is " + (enableAcra ? "enabled" : "disabled") + " for " + app.getPackageName() + ", initializing...";
            aCRALog.i(string, (String)object);
            ErrorReporterImpl reporter = new ErrorReporterImpl(app, config, enableAcra, supportedAndroidVersion, checkReportsOnApplicationStart);
            errorReporter = reporter;
            prefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)reporter);
        }
    }

    public static /* synthetic */ void init$default(Application application, CoreConfiguration coreConfiguration, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        ACRA.init(application, coreConfiguration, bl);
    }

    public final boolean isInitialised() {
        return errorReporter instanceof ErrorReporterImpl;
    }

    @JvmStatic
    public static final boolean isACRASenderServiceProcess() {
        String processName = INSTANCE.currentProcessName();
        boolean $i$f$debug = false;
        if (DEV_LOGGING) {
            String string = LOG_TAG;
            ACRALog aCRALog = log;
            boolean bl = false;
            String string2 = "ACRA processName='" + processName + "'";
            aCRALog.d(string, string2);
        }
        return processName != null && StringsKt.endsWith$default((String)processName, (String)ACRA_PRIVATE_PROCESS_NAME, (boolean)false, (int)2, null);
    }

    private final String currentProcessName() {
        String string;
        try {
            String $this$trim$iv = new StreamReader("/proc/self/cmdline").read();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        catch (IOException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ACRA.init$default(app, builder, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        ACRA.init$default(app, null, false, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ACRA.init$default(app, config, false, 4, null);
    }

    static {
        String string = ACRA.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        LOG_TAG = string;
        log = new AndroidLogDelegate();
        errorReporter = StubCreator.INSTANCE.createErrorReporterStub();
    }
}

