/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.auto.service.AutoService;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J0\u0010\u0003\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012\u00a8\u0006\u0014"}, d2={"Lorg/acra/collector/SharedPreferencesCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "collect", "Lorg/json/JSONObject;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "", "reportField", "Lorg/acra/ReportField;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "filteredKey", "", "key", "", "acra-core_release"})
@AutoService(value={Collector.class})
public class SharedPreferencesCollector
extends BaseReportFieldCollector {
    public SharedPreferencesCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.USER_EMAIL, ReportField.SHARED_PREFERENCES};
        super(reportFieldArray);
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        switch (WhenMappings.$EnumSwitchMapping$0[reportField.ordinal()]) {
            case 1: {
                target.put(ReportField.USER_EMAIL, new SharedPreferencesFactory(context, config).create().getString("acra.user.email", null));
                break;
            }
            case 2: {
                target.put(ReportField.SHARED_PREFERENCES, this.collect(context, config));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private JSONObject collect(Context context, CoreConfiguration config) throws JSONException {
        JSONObject result = new JSONObject();
        Map sharedPrefs = new TreeMap();
        Iterator iterator = sharedPrefs;
        String object3 = "default";
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getDefaultSharedPreferences(...)");
        Object object = sharedPreferences;
        iterator.put(object3, object);
        for (String string : config.getAdditionalSharedPreferences()) {
            SharedPreferences sharedPreferences2;
            object = sharedPrefs;
            Intrinsics.checkNotNullExpressionValue((Object)context.getSharedPreferences(string, 0), (String)"getSharedPreferences(...)");
            object.put(string, sharedPreferences2);
        }
        for (Map.Entry entry : sharedPrefs.entrySet()) {
            String sharedPrefId = (String)entry.getKey();
            SharedPreferences prefs = (SharedPreferences)entry.getValue();
            Map prefEntries = prefs.getAll();
            if (prefEntries.isEmpty()) {
                result.put(sharedPrefId, (Object)"empty");
                continue;
            }
            Iterator iterator2 = prefEntries.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(k, (String)"next(...)");
                if (!this.filteredKey(config, (String)k)) continue;
                iterator2.remove();
            }
            result.put(sharedPrefId, (Object)new JSONObject(prefEntries));
        }
        return result;
    }

    private boolean filteredKey(CoreConfiguration config, String key) {
        for (String regex : config.getExcludeMatchingSharedPreferencesKeys()) {
            CharSequence charSequence;
            if (!new Regex(regex).matches(charSequence = (CharSequence)key)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportField.values().length];
            try {
                nArray[ReportField.USER_EMAIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportField.SHARED_PREFERENCES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

