/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Handler;
import android.support.annotation.NonNull;
import java.io.File;
import java.util.Calendar;
import org.acra.config.CoreConfiguration;
import org.acra.file.BulkReportDeleter;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.interaction.ReportInteractionExecutor;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.sender.SenderServiceStarter;
import org.acra.util.PackageManagerWrapper;

public final class ApplicationStartupProcessor {
    private final Context context;
    private final CoreConfiguration config;
    private final BulkReportDeleter reportDeleter;
    private final ReportLocator reportLocator;

    public ApplicationStartupProcessor(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.context = context;
        this.config = config;
        this.reportDeleter = new BulkReportDeleter(context);
        this.reportLocator = new ReportLocator(context);
    }

    public void checkReports(boolean enableAcra) {
        Calendar now = Calendar.getInstance();
        new Handler(this.context.getMainLooper()).post(() -> new Thread(() -> {
            if (this.config.deleteOldUnsentReportsOnApplicationStart()) {
                this.deleteUnsentReportsFromOldAppVersion();
            }
            if (this.config.deleteUnapprovedReportsOnApplicationStart()) {
                this.reportDeleter.deleteReports(false, 1);
            }
            if (enableAcra) {
                this.sendApprovedReports();
                this.approveOneReport(now);
            }
        }).start());
    }

    private void approveOneReport(Calendar ignoreReportsAfter) {
        File[] reports = this.reportLocator.getUnapprovedReports();
        if (reports.length == 0) {
            return;
        }
        if (new CrashReportFileNameParser().getTimestamp(reports[0].getName()).before(ignoreReportsAfter)) {
            new ReportInteractionExecutor(this.context, this.config).performInteractions(reports[0]);
        }
    }

    private void deleteUnsentReportsFromOldAppVersion() {
        SharedPreferences prefs = new SharedPreferencesFactory(this.context, this.config).create();
        long lastVersionNr = prefs.getInt("acra.lastVersionNr", 0);
        int appVersion = this.getAppVersion();
        if ((long)appVersion > lastVersionNr) {
            this.reportDeleter.deleteReports(true, 0);
            this.reportDeleter.deleteReports(false, 0);
            prefs.edit().putInt("acra.lastVersionNr", appVersion).apply();
        }
    }

    private void sendApprovedReports() {
        File[] reportFiles = this.reportLocator.getApprovedReports();
        if (reportFiles.length == 0) {
            return;
        }
        SenderServiceStarter starter = new SenderServiceStarter(this.context, this.config);
        starter.startService(false, false);
    }

    private int getAppVersion() {
        PackageManagerWrapper packageManagerWrapper = new PackageManagerWrapper(this.context);
        PackageInfo packageInfo = packageManagerWrapper.getPackageInfo();
        return packageInfo == null ? 0 : packageInfo.versionCode;
    }
}

