/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.acra.ACRA;
import org.acra.collections.ImmutableList;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.sender.ReportDistributor;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderFactory;
import org.acra.util.InstanceCreator;
import org.acra.util.ToastSender;

public class SenderService
extends JobIntentService {
    public static final String EXTRA_ONLY_SEND_SILENT_REPORTS = "onlySendSilentReports";
    public static final String EXTRA_APPROVE_REPORTS_FIRST = "approveReportsFirst";
    public static final String EXTRA_ACRA_CONFIG = "acraConfig";
    private final ReportLocator locator = new ReportLocator((Context)this);

    protected void onHandleWork(@NonNull Intent intent) {
        if (!intent.hasExtra(EXTRA_ACRA_CONFIG)) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "SenderService was started but no valid intent was delivered, will now quit");
            }
            return;
        }
        boolean onlySendSilentReports = intent.getBooleanExtra(EXTRA_ONLY_SEND_SILENT_REPORTS, false);
        boolean approveReportsFirst = intent.getBooleanExtra(EXTRA_APPROVE_REPORTS_FIRST, false);
        CoreConfiguration config = (CoreConfiguration)intent.getSerializableExtra(EXTRA_ACRA_CONFIG);
        ImmutableList<Class<? extends ReportSenderFactory>> senderFactoryClasses = config.reportSenderFactoryClasses();
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "About to start sending reports from SenderService");
        }
        try {
            String toast;
            List<ReportSender> senderInstances = this.getSenderInstances(config, (Collection<Class<? extends ReportSenderFactory>>)senderFactoryClasses);
            if (approveReportsFirst) {
                this.markReportsAsApproved();
            }
            File[] reports = this.locator.getApprovedReports();
            ReportDistributor reportDistributor = new ReportDistributor((Context)this, config, senderInstances);
            int reportsSentCount = 0;
            CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
            boolean anyNonSilent = false;
            for (File report : reports) {
                boolean isNonSilent;
                boolean bl = isNonSilent = !fileNameParser.isSilent(report.getName());
                if (onlySendSilentReports && isNonSilent) continue;
                anyNonSilent |= isNonSilent;
                if (reportsSentCount >= 5) break;
                if (!reportDistributor.distribute(report)) continue;
                ++reportsSentCount;
            }
            if (anyNonSilent && (toast = reportsSentCount > 0 ? config.reportSendSuccessToast() : config.reportSendFailureToast()) != null) {
                new Handler(Looper.getMainLooper()).post(() -> ToastSender.sendToast((Context)this, toast, 1));
            }
        }
        catch (Exception e) {
            ACRA.log.e(ACRA.LOG_TAG, "", e);
        }
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Finished sending reports from SenderService");
        }
    }

    @NonNull
    private List<ReportSender> getSenderInstances(@NonNull CoreConfiguration config, @NonNull Collection<Class<? extends ReportSenderFactory>> factoryClasses) {
        ArrayList<ReportSender> reportSenders = new ArrayList<ReportSender>();
        InstanceCreator instanceCreator = new InstanceCreator();
        for (ReportSenderFactory factory : instanceCreator.create(factoryClasses)) {
            reportSenders.add(factory.create((Context)this.getApplication(), config));
        }
        return reportSenders;
    }

    private void markReportsAsApproved() {
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Mark all pending reports as approved.");
        }
        for (File report : this.locator.getUnapprovedReports()) {
            File approvedReport = new File(this.locator.getApprovedFolder(), report.getName());
            if (report.renameTo(approvedReport)) continue;
            ACRA.log.w(ACRA.LOG_TAG, "Could not rename approved report from " + report + " to " + approvedReport);
        }
    }
}

